package com.elitescloud.cloudt.system.service.devops.init;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import lombok.extern.slf4j.Slf4j;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 系统设置.
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/8
 */
@Slf4j
public class SettingInitProvider extends AbstractBasicDataInitProvider {

    @Override
    public String typeName() {
        return "系统设置";
    }

    @Override
    public String tableName() {
        return "sys_setting";
    }

    @Override
    public List<String> fields() {
        return List.of("setting_no", "setting_name", "setting_type", "setting_type2", "setting_status", "setting_desc",
                "setting_val", "def_val", "sort_no", "create_time", "modify_time");
    }

    @Override
    public Map<String, String> fieldTitles() {
        Map<String, String> titles = new LinkedHashMap<>(16);
        titles.put("setting_no", "编码");
        titles.put("setting_name", "名称");
        titles.put("setting_type", "类型");
        titles.put("setting_type2", "类型2");
        titles.put("setting_status", "状态");
        titles.put("setting_desc", "描述");
        titles.put("setting_val", "值");
        titles.put("def_val", "默认值");
        titles.put("sort_no", "顺序");
        titles.put("create_time", "创建时间");
        titles.put("modify_time", "最后修改时间");
        return titles;
    }

    @Override
    public boolean isTenantData() {
        return true;
    }

    @Override
    public List<OrderItem> orderItems() {
        return List.of(OrderItem.desc("create_time"));
    }

    @Override
    public UpdateType convertForImport(Map<String, Object> data, List<Map<String, Object>> currentData, List<Map<String, Object>> lastStepData) {
        var setting_no = this.getStringValue(data, "setting_no", null);
        Assert.notBlank(setting_no, "设置编码为空");

        if (currentData.isEmpty()) {
            return UpdateType.ADD;
        }

        var id = currentData.stream()
                .filter(t -> setting_no.equals(t.get("setting_no")))
                .findFirst()
                .map(t -> t.get("id"))
                .orElse(null);
        data.put("id", id);
        return id == null ? UpdateType.ADD : UpdateType.UPDATE;
    }
}
