package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.config.AuthorizationSdkProperties;
import com.elitescloud.boot.auth.model.OAuthToken;
import com.elitescloud.boot.auth.provider.common.AuthorizationConstant;
import com.elitescloud.boot.auth.provider.provider.user.UserDetailManager;
import com.elitescloud.boot.auth.provider.security.grant.InternalAuthenticationGranter;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.service.AuthUserService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.function.Supplier;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/16
 */
@Slf4j
@Service
public class AuthUserServiceImpl extends BaseServiceImpl implements AuthUserService {

    @Autowired
    private TextEncryptor encryptor;
    @Autowired
    private UserDetailManager userDetailManager;
    @Autowired
    private InternalAuthenticationGranter authenticationGranter;
    @Autowired
    private AuthorizationSdkProperties authorizationSdkProperties;

    @Override
    public ApiResult<OAuthToken> authByUserId(String userIdCypher) {
        if (CharSequenceUtil.isBlank(userIdCypher)) {
            return ApiResult.fail("用户ID为空");
        }
        String userIdTxt = null;
        try {
            userIdTxt = this.decrypt(userIdCypher);
        } catch (Exception e) {
            return ApiResult.fail("解密用户ID失败，请确认加密方式正确");
        }

        String finalUserIdTxt = userIdTxt;
        return this.authentication(() -> userDetailManager.loadUserById(finalUserIdTxt));
    }

    private ApiResult<OAuthToken> authentication(Supplier<GeneralUserDetails> userDetailsSupplier) {
        // 加载账号信息
        GeneralUserDetails userDetails = null;
        try {
            userDetails = userDetailsSupplier.get();
        } catch (Exception e) {
            log.info("认证失败：", e);
            return ApiResult.fail("认证失败，" + e.getMessage());
        }

        // 生成token
        var clientId = authorizationSdkProperties.getCasClient().getOauth2Client().getClientId();
        if (CharSequenceUtil.isNotBlank(clientId)) {
            HttpServletRequest request = HttpServletUtil.currentRequest();
            if (request != null) {
                request.setAttribute(AuthorizationConstant.REQUEST_ATTRIBUTE_CLIENT_ID, clientId);
            }
        }
        var authentication = new InternalAuthenticationGranter.InternalAuthenticationToken(InternalAuthenticationGranter.IdType.USER_ID, userDetails.getUserId().toString());
        try {
            var token = authenticationGranter.authenticate(null, null, authentication);
            return ApiResult.ok(token);
        } catch (Exception e) {
            log.info("认证异常：", e);
            return ApiResult.fail("认证失败，" + e.getMessage());
        }
    }

    private String decrypt(String cipher) {
        if (CharSequenceUtil.isBlank(cipher)) {
            return null;
        }

        try {
            return encryptor.decrypt(cipher);
        } catch (Exception e) {
            log.info("解密失败，密文：{}，异常：", cipher, e);
            throw new IllegalArgumentException("解密失败：" + e.getMessage());
        }
    }
}
