package com.elitescloud.cloudt.system.service.impl;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.system.service.EmpGroupQueryService;
import com.elitescloud.cloudt.system.service.repo.EmpGroupEmpRepoProc;
import com.elitescloud.cloudt.system.service.repo.EmpGroupRepoProc;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2/14/2023
 */
@Service
@TenantTransaction(isolateType = TenantIsolateType.TENANT)
public class EmpGroupQueryServiceImpl extends BaseServiceImpl implements EmpGroupQueryService {

    @Autowired
    private EmpGroupRepoProc repoProc;
    @Autowired
    private EmpGroupEmpRepoProc empGroupEmpRepoProc;

    @Override
    public ApiResult<List<Long>> getUserIdsByGroupCode(String groupCode) {
        Assert.hasText(groupCode, "员工组编号为空");

        var userIds = empGroupEmpRepoProc.queryUserIdOfGroup(groupCode);
        return ApiResult.ok(userIds);
    }

    @Override
    public ApiResult<Map<String, List<Long>>> queryUserIdsByGroupCodes(Set<String> groupCodes) {
        if (groupCodes != null) {
            groupCodes = groupCodes.stream().filter(StringUtils::hasText).collect(Collectors.toSet());
        }

        var groupCodeUserIdMap = empGroupEmpRepoProc.queryUserIdOfGroup(groupCodes);
        return ApiResult.ok(groupCodeUserIdMap);
    }
}
