package com.elitescloud.cloudt.system.service.impl;

import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.service.PlatformQueryService;
import com.elitescloud.cloudt.system.service.repo.SysVersionRepoProc;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/11/23
 */
@Service
public class PlatformQueryServiceImpl implements PlatformQueryService {

    @Autowired
    private SysVersionRepoProc versionRepoProc;

    @Override
    public ApiResult<List<CodeNameParam>> listProjectVersion() {
        var versionList = versionRepoProc.queryVersionList()
                .stream().map(t -> new CodeNameParam(t, t))
                .collect(Collectors.toList());
        return ApiResult.ok(versionList);
    }
}
