package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.cloudt.system.model.entity.SysResourceByteDO;
import com.elitescloud.cloudt.system.service.ResourceByteQueryService;
import com.elitescloud.cloudt.system.service.repo.ResourceByteRepoProc;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

import java.nio.charset.StandardCharsets;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/26
 */
@Service
@Slf4j
public class ResourceByteQueryServiceImpl implements ResourceByteQueryService {

    @Autowired
    private ResourceByteRepoProc repoProc;

    @Override
    public ResponseEntity<StreamingResponseBody> download(String fileCode) {
        SysResourceByteDO resourceByteDO = StringUtils.hasText(fileCode) ? repoProc.getByResourceKey(fileCode) : null;
        if (resourceByteDO == null || ArrayUtil.isEmpty(resourceByteDO)) {
            return ResponseEntity.notFound().build();
        }

        // 下载文件
        var contentDisposition = ContentDisposition.builder("attachment")
                .filename(resourceByteDO.getShowName(), StandardCharsets.UTF_8)
                .build();
        return ResponseEntity.ok()
                .contentType(ObjectUtil.defaultIfNull(parseMediaType(resourceByteDO.getMimeType()), MediaType.APPLICATION_OCTET_STREAM))
                .header(HttpHeaders.CONTENT_DISPOSITION, contentDisposition.toString())
                .contentLength(resourceByteDO.getResource().length)
                .body(outputStream -> {
                    try {
                        StreamUtils.copy(resourceByteDO.getResource(), outputStream);
                    } catch (Exception e) {
                        log.error("下载资源文件异常：", e);
                    }
                });
    }

    private MediaType parseMediaType(String mimeType) {
        if (CharSequenceUtil.isBlank(mimeType)) {
            return null;
        }
        var types = mimeType.split("/");
        return types.length > 1 ? new MediaType(types[0], types[1]) : new MediaType(types[0]);
    }
}
