package com.elitescloud.cloudt.system.service.impl;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.convert.SysPageFiledConfigConvert;
import com.elitescloud.cloudt.system.model.entity.QSysPageFieldConfigDtlDO;
import com.elitescloud.cloudt.system.model.entity.SysPageFieldConfigDO;
import com.elitescloud.cloudt.system.model.entity.SysPageFieldConfigDtlDO;
import com.elitescloud.cloudt.system.model.vo.query.extend.SysPageFieldConfigDtlParam;
import com.elitescloud.cloudt.system.model.vo.query.extend.SysPageFieldConfigDtlQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.extend.SysPageFieldConfigQueryVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.SysPageFieldConfigSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.SysPageFieldConfigUpdateVO;
import com.elitescloud.cloudt.system.provider.imports.param.PageFieldImportBO;
import com.elitescloud.cloudt.system.service.SysPageFieldConfigService;
import com.elitescloud.cloudt.system.service.repo.SysPageFieldConfigDtlRepo;
import com.elitescloud.cloudt.system.service.repo.SysPageFieldConfigDtlRepoProc;
import com.elitescloud.cloudt.system.service.repo.SysPageFieldConfigRepo;
import com.elitescloud.cloudt.system.service.repo.SysPageFieldConfigRepoProc;
import com.elitescloud.cloudt.system.service.util.JpaPredicateBuilder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/9/8 14:09
 */
@Service
@Slf4j
public class SysPageFieldConfigServiceImpl implements SysPageFieldConfigService {
    @Autowired
    private SysPageFieldConfigDtlRepo sysPageFieldConfigDtlRepo;
    @Autowired
    private SysPageFieldConfigRepo sysPageFieldConfigRepo;
    @Autowired
    private SysPageFieldConfigRepoProc sysPageFieldConfigRepoProc;
    @Autowired
    private SysPageFieldConfigDtlRepoProc sysPageFieldConfigDtlRepoProc;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<String> savePageFieldConfig(SysPageFieldConfigSaveVO saveVO) {
        var sdo = SysPageFiledConfigConvert.INSTANCE.voTodo(saveVO);
        var listDO = sysPageFieldConfigRepo.findByConfigCode(sdo.getConfigCode());
        if (listDO != null && listDO.size() > 0) {
            return ApiResult.fail("配置编码不能重复，已经存在");
        }
        sysPageFieldConfigRepo.save(sdo);
        var dtlDoList = saveVO.getDtlVO().stream().map(SysPageFiledConfigConvert.INSTANCE::voTodo)
                .collect(Collectors.toList());
        sysPageFieldConfigDtlRepo.saveAll(dtlDoList);
        return ApiResult.ok(sdo.getId().toString());
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Boolean> updatePageFieldConfig(Long id, SysPageFieldConfigUpdateVO updateVO) {

        sysPageFieldConfigRepo.findById(id).ifPresentOrElse(sysPageFieldConfigDO -> {
                   sysPageFieldConfigDO.setAppCode(updateVO.getAppCode());
                    sysPageFieldConfigDO.setAppName(updateVO.getAppName());
                    sysPageFieldConfigDO.setConfigName(updateVO.getConfigName());
                    sysPageFieldConfigDO.setRemark(updateVO.getRemark());
                    sysPageFieldConfigDO.setEnabled(updateVO.getEnabled());
                    sysPageFieldConfigRepo.save(sysPageFieldConfigDO);
                    //更新走全删全插
                    sysPageFieldConfigDtlRepo.deleteAllByConfigCode(sysPageFieldConfigDO.getConfigCode());
                    var dtlDoList = updateVO.getDtlVO().stream()
                            .map(dtlVO -> {
                               var dtlDo= SysPageFiledConfigConvert.INSTANCE.voTodo(dtlVO);
                                dtlDo.setAppCode(sysPageFieldConfigDO.getAppCode());
                                dtlDo.setAppName(sysPageFieldConfigDO.getAppName());
                                dtlDo.setConfigCode(sysPageFieldConfigDO.getConfigCode());
                                dtlDo.setConfigName(sysPageFieldConfigDO.getConfigName());
                                return dtlDo;
                            })
                            .collect(Collectors.toList());
                    sysPageFieldConfigDtlRepo.saveAll(dtlDoList);
                },
                () -> {
                    throw new BusinessException("id不存在");
                });
        return ApiResult.ok(true);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Long> save(PageFieldImportBO importBO) {
        var existsConfig = sysPageFieldConfigRepoProc.existsConfigCode(importBO.getConfigCode());
        if (!existsConfig) {
            // 不存在则新增配置
            SysPageFieldConfigDO configDO = new SysPageFieldConfigDO();
            configDO.setAppCode(importBO.getAppCode());
            configDO.setAppName(importBO.getAppName());
            configDO.setConfigName(importBO.getConfigName());
            configDO.setConfigCode(importBO.getConfigCode());
            configDO.setEnabled(true);
            sysPageFieldConfigRepoProc.save(configDO);
        }

        SysPageFieldConfigDtlDO configDtlDO = new SysPageFieldConfigDtlDO();
        configDtlDO.setAppCode(importBO.getAppCode());
        configDtlDO.setAppName(importBO.getAppName());
        configDtlDO.setConfigName(importBO.getConfigName());
        configDtlDO.setConfigCode(importBO.getConfigCode());
        configDtlDO.setFieldName(importBO.getFieldName());
        configDtlDO.setFieldCode(importBO.getFieldCode());
        configDtlDO.setFieldRequired(importBO.getFieldRequired());
        configDtlDO.setFieldAlias(importBO.getFieldAlias());
        configDtlDO.setFieldOrder(importBO.getFieldOrder());
        configDtlDO.setFieldHidden(importBO.getFieldHidden());
        configDtlDO.setFieldEdit(importBO.getFieldEdit());
        configDtlDO.setFieldDefaultValue(importBO.getFieldDefaultValue());
        configDtlDO.setFieldWidth(importBO.getFieldWidth());
        configDtlDO.setFieldDescription(importBO.getFieldDescription());
        configDtlDO.setLinenum(0D);
        sysPageFieldConfigDtlRepoProc.save(configDtlDO);

        return ApiResult.ok(configDtlDO.getId());
    }

    @Override
    public ApiResult<PagingVO<SysPageFieldConfigDtlQueryVO>> queryPageFieldConfigDtl(
            SysPageFieldConfigDtlParam param) {
        var QDO = QSysPageFieldConfigDtlDO.sysPageFieldConfigDtlDO;

        var predicate = JpaPredicateBuilder.builder()
                .and(QDO.appCode::eq, param.getAppCode())
                .and(QDO.configCode::eq, param.getConfigCode())
                .and(QDO.fieldCode::eq, param.getFieldCode())
                .and(QDO.fieldAlias::contains, param.getFieldAlias())
                .and(QDO.configName::contains, param.getConfigName())
                .and(QDO.fieldName::contains, param.getFieldName())

                .and(QDO.fieldRequired::eq, param.getFieldRequired())
                //   .and( QDO.id::in,idList)
                //    .and( QDO.createTime::between, LocalDateTime.now(),LocalDateTime.now())
                .getPredicate();
        var page = sysPageFieldConfigDtlRepo.findAll(predicate, param.getPageRequest());
        var pagingVo = PagingVO.<SysPageFieldConfigDtlQueryVO>builder()
                .total(page.getTotalElements())
                .setRecords(page.get().map(SysPageFiledConfigConvert.INSTANCE::doToVo)
                        .collect(Collectors.toList()));
        return ApiResult.ok(pagingVo);
    }

    @Override
    public ApiResult<SysPageFieldConfigQueryVO> getPageFieldConfig(String configCode) {
        var pageFieldConfig = sysPageFieldConfigRepo.findByConfigCode(configCode);
        if (pageFieldConfig != null && pageFieldConfig.size() == 1) {
            var queryVo = SysPageFiledConfigConvert.INSTANCE.doToVo(pageFieldConfig.get(0));
            List<SysPageFieldConfigDtlQueryVO> dtlQueryVo =
                    sysPageFieldConfigDtlRepo.findAllByConfigCode(configCode)
                            .stream().map(SysPageFiledConfigConvert.INSTANCE::doToVo)
                            .collect(Collectors.toList());
            queryVo.setDtlVO(dtlQueryVo);
            return ApiResult.ok(queryVo);
        } else {
            return ApiResult.ok();
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Boolean> deletePageFieldConfig(Long id) {
        sysPageFieldConfigRepo.findById(id)
                .ifPresentOrElse(sysPageFieldConfigDO -> {
                            sysPageFieldConfigRepo.deleteById(id);
                            sysPageFieldConfigDtlRepo.deleteAllByConfigCode(sysPageFieldConfigDO.getConfigCode());
                        },
                        () -> {
                            throw new BusinessException("id不存在"+id);
                        });
        return ApiResult.ok(true);
    }

    @Override
    @Transactional
    public ApiResult<Boolean> deletePageFieldConfigDtl(Long id) {
        sysPageFieldConfigDtlRepo.findById(id)
                .ifPresentOrElse(sysPageFieldConfigDtlDO -> {
                        sysPageFieldConfigDtlRepo.delete(sysPageFieldConfigDtlDO);
                        var list= sysPageFieldConfigDtlRepo
                                .findByConfigCodeAndIdNot(sysPageFieldConfigDtlDO.getConfigCode(),id);
                        if(CollectionUtils.isEmpty(list)){
                            sysPageFieldConfigRepo.deleteByConfigCode(sysPageFieldConfigDtlDO.getConfigCode());
                        }
                    },
                () -> {
                    throw new BusinessException("id不存在"+id);
                });
        return ApiResult.ok();
    }
}
