package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.lang.Assert;
import com.el.coordinator.core.common.utils.BeanCopyUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.system.service.SysWatermarkConfigService;
import com.elitescloud.cloudt.system.service.param.SysWatermarkConfigCreateParam;
import com.elitescloud.cloudt.system.service.param.SysWatermarkConfigQueryParam;
import com.elitescloud.cloudt.system.service.param.SysWatermarkConfigUpdateParam;
import com.elitescloud.cloudt.system.service.repo.SysWatermarkConfigRepo;
import com.elitescloud.cloudt.system.service.vo.SysWatermarkConfigVO;
import com.elitescloud.cloudt.system.convert.SysWatermarkConfigConvert;
import com.elitescloud.cloudt.system.model.entity.QSysWatermarkConfigDO;
import com.elitescloud.cloudt.system.model.entity.SysWatermarkConfigDO;
import com.elitescloud.cloudt.system.service.repo.SysWatermarkConfigRepoProc;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import lombok.RequiredArgsConstructor;
import lombok.val;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author roman.zhang
 * @since 2022-03-25 15:17:52
 */
@Service("sysWatermarkConfigService")
@RequiredArgsConstructor
public class SysWatermarkConfigServiceImpl implements SysWatermarkConfigService {
    
    private final SysWatermarkConfigRepo sysWatermarkConfigRepo;
    
    private final SysWatermarkConfigRepoProc sysWatermarkConfigRepoProc;
    
 
    @Override
    @SysCodeProc
    public PagingVO<SysWatermarkConfigVO> search(SysWatermarkConfigQueryParam param){
        val ret = sysWatermarkConfigRepo.findAll(sysWatermarkConfigRepoProc.where(param), param.getPageRequest());
        val vos = ret.getContent().stream().map(SysWatermarkConfigConvert.INSTANCE::doToVO).collect(Collectors.toList());
        return PagingVO.<SysWatermarkConfigVO>builder()
                .total(ret.getTotalElements())
                .records(vos)
                .build();
    }
 
    @Override
    @SysCodeProc
    public Optional<SysWatermarkConfigVO> findCodeOne(String itemCode) {
        JPAQuery<SysWatermarkConfigVO> jpaQuery = sysWatermarkConfigRepoProc.select(null);
        val jpaQDo = QSysWatermarkConfigDO.sysWatermarkConfigDO;
        //设置查询条件
        //jpaQuery.where(jpaQDo.itemCode.eq(itemCode));
        SysWatermarkConfigVO vo = jpaQuery.fetchOne();
        return Optional.ofNullable(vo);
    }

    @Override
    public Optional<SysWatermarkConfigVO> findOne() {
        Optional<SysWatermarkConfigDO> byOne = sysWatermarkConfigRepo.findByOne();
        Optional<SysWatermarkConfigVO> sysWatermarkConfigVO = byOne.map(SysWatermarkConfigConvert.INSTANCE::doToVO);
        if (byOne.isPresent()) {
            String[] split = byOne.get().getDynamicFont().split(",");
            List<String> dynamics = Arrays.asList(split);
            sysWatermarkConfigVO.get().setDynamicField(dynamics);
        }
        return sysWatermarkConfigVO;
    }

    @Override
    @SysCodeProc
    public Optional<SysWatermarkConfigVO> findIdOne(Long id) {
        return sysWatermarkConfigRepo.findById(id).map(SysWatermarkConfigConvert.INSTANCE::doToVO);
    }
    @Override
    @SysCodeProc
    public List<SysWatermarkConfigVO> findIdBatch(List<Long> idList) {

         return sysWatermarkConfigRepo.findAllById(idList).stream().map(
               SysWatermarkConfigConvert.INSTANCE::doToVO
        ).collect(Collectors.toList());
    }

    
    
    @Override
    @Transactional
    public Long createOne(SysWatermarkConfigCreateParam param){
        Assert.notNull(param.getDynamicField(),"该字段不能为空");
       SysWatermarkConfigDO sysWatermarkConfigDO = SysWatermarkConfigConvert.INSTANCE.creatParamToDo(param);
        List<String> dynamicFields = param.getDynamicField();
        String dynamicFiled = "";
        for (int i = 0; i <= dynamicFields.size() - 1; i++) {
            dynamicFiled = dynamicFiled + dynamicFields.get(i);
            if(i != dynamicFields.size() - 1){
                dynamicFiled = dynamicFiled + ",";
            }
        }

        if(dynamicFiled != null){
            sysWatermarkConfigDO.setDynamicFont(dynamicFiled);
        }
       return sysWatermarkConfigRepo.save(sysWatermarkConfigDO).getId();
    }
    
    @Override
    @Transactional
    public List<Long> createBatch(List<SysWatermarkConfigCreateParam> list){
        List<SysWatermarkConfigDO> dos = list.stream().map(SysWatermarkConfigConvert.INSTANCE::creatParamToDo).collect(Collectors.toList());
       return sysWatermarkConfigRepo.saveAll(dos).stream().map(SysWatermarkConfigDO::getId).collect(Collectors.toList());
    }
    
    @Override
    @Transactional
    public void update(SysWatermarkConfigUpdateParam param) {
      SysWatermarkConfigDO objDo = SysWatermarkConfigConvert.INSTANCE.updateParamToDo(param);
        Optional<SysWatermarkConfigDO> optional = sysWatermarkConfigRepo.findById(objDo.getId());
        if(optional.isPresent()){
             BeanCopyUtil.beanCopyWithIngore(objDo, optional.get(), BeanCopyUtil.getNullPropertyNames(objDo));
             sysWatermarkConfigRepo.save(optional.get());
        }else{
            throw new BusinessException(ApiCode.FAIL,"修改失败，数据不存在"+objDo.getId());
        }
    }

    @Override
    @Transactional
    public void updateDeleteFlag(Long id) {
        val jpaQDo = QSysWatermarkConfigDO.sysWatermarkConfigDO;
        Predicate predicate = jpaQDo.isNotNull();
        predicate = ExpressionUtils.and(predicate, jpaQDo.id.eq(id));
                Optional<SysWatermarkConfigDO> optionalItem=sysWatermarkConfigRepo.findOne(predicate);
        if(optionalItem.isPresent()) {
            SysWatermarkConfigDO do1 = optionalItem.get();
            do1.setDeleteFlag(1);
            sysWatermarkConfigRepo.save(do1);
        }else{
             throw new BusinessException(ApiCode.FAIL,"修改失败，数据不存在"+id);
        }
    }

    
    
    @Override
    @Transactional
    public void deleteOne(Long id) {
     
      this.sysWatermarkConfigRepo.deleteById(id) ;
      
    }
    
    @Override
    @Transactional
    public void deleteBatch(List<Long> list) {
        list.forEach(id-> sysWatermarkConfigRepo.deleteById(id));
    }
}


