package com.elitescloud.cloudt.system.service.impl;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.system.service.ThirdPartAccountQueryService;
import com.elitescloud.cloudt.system.service.repo.ThirdPartyAccountRepoProc;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2/14/2023
 */
@Service
@TenantTransaction(isolateType = TenantIsolateType.DEFAULT)
@TenantOrgTransaction(useTenantOrg = false)
public class ThirdPartAccountQueryServiceImpl extends BaseServiceImpl implements ThirdPartAccountQueryService {

    @Autowired
    private ThirdPartyAccountRepoProc repoProc;

    @Override
    public ApiResult<Long> getTenantIdOfAccount(String account) {
        Assert.hasText(account, "账号为空");

        var tenantId = repoProc.getTenantIdByAccount(account);
        return ApiResult.ok(tenantId);
    }
}
