package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.el.coordinator.boot.fsm.service.FileService;
import com.elitescloud.boot.common.param.AreaVO;
import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.core.support.verifycode.VerifyCodeManager;
import com.elitescloud.cloudt.security.common.InnerUserEnum;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.constant.UserType;
import com.elitescloud.cloudt.system.convert.AreaConvert;
import com.elitescloud.cloudt.system.convert.UserConvert;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.service.AreaQueryService;
import com.elitescloud.cloudt.system.service.manager.UserMngManager;
import com.elitescloud.cloudt.system.service.model.entity.SysUserDO;
import com.elitescloud.cloudt.system.service.repo.TenantUserRepoProc;
import com.elitescloud.cloudt.system.service.repo.UserRepoProc;
import com.elitescloud.cloudt.system.service.repo.UserTypeRepoProc;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 用户服务基础类.
 *
 * @author Kaiser（wang shao）
 * @date 3/3/2023
 */
abstract class UserBaseServiceImpl extends BaseServiceImpl {
    protected static final UserConvert CONVERT = UserConvert.INSTANCE;
    protected static final AreaConvert CONVERT_AREA = AreaConvert.INSTANCE;

    @Autowired
    protected UserRepoProc userRepoProc;
    @Autowired
    protected UserTypeRepoProc userTypeRepoProc;
    @Autowired
    protected TenantUserRepoProc tenantUserRepoProc;
    @Autowired
    protected UserMngManager userManager;
    @Autowired
    protected VerifyCodeManager verifyCodeManager;
    @Autowired
    protected AreaQueryService areaQueryService;
    @Autowired(required = false)
    protected FileService fileService;

    protected Map<Long, List<CodeNameParam>> convertUserType(GeneralUserDetails currentUser, Set<Long> userIds) {
        var tenantId = super.currentTenantId();
        var userTypeMap = userTypeRepoProc.getUserTypes(userIds, tenantId);

        // 系统管理员
        if (userIds.contains(InnerUserEnum.ADMIN.getId())) {
            userTypeMap.computeIfAbsent(InnerUserEnum.ADMIN.getId(), t -> new HashSet<>(4)).add(UserType.ADMIN_SYSTEM.getValue());
        }
        // 租户管理员
        Long tenantAdminId = currentUser.getTenant() == null ? null : currentUser.getTenant().getSysUserId();
        if (tenantAdminId != null && userIds.contains(tenantAdminId)) {
            userTypeMap.computeIfAbsent(tenantAdminId, t -> new HashSet<>(4)).add(UserType.ADMIN_TENANT.getValue());
        }

        if (userTypeMap.isEmpty()) {
            return Collections.emptyMap();
        }

        var udcMap = super.udcMap(new UserType());
        if (udcMap.isEmpty()) {
            return Collections.emptyMap();
        }

        Map<Long, List<CodeNameParam>> result = new HashMap<>(userIds.size());
        for (Map.Entry<Long, Set<String>> entry : userTypeMap.entrySet()) {
            var types = entry.getValue().stream().filter(udcMap::containsKey)
                    .map(t -> new CodeNameParam(t, udcMap.get(t))).collect(Collectors.toList());
            result.put(entry.getKey(), types);
        }
        return result;
    }

    protected AreaVO convertAreaVO(SysUserDO userDo, Map<String, String> nameMap) {
        AreaVO areaVO = new AreaVO();
        areaVO.setProvinceCode(userDo.getProvinceCode());
        areaVO.setProvinceName(nameMap.get(userDo.getProvinceCode()));
        areaVO.setCityCode(userDo.getCityCode());
        areaVO.setCityName(nameMap.get(userDo.getCityCode()));
        areaVO.setCountyCode(userDo.getCountyCode());
        areaVO.setCountyName(nameMap.get(userDo.getCountyCode()));

        return areaVO;
    }

    protected SysUserBasicDTO fillTenantUser(SysUserBasicDTO basic) {
        if (basic == null) {
            return null;
        }
        // 启用状态
        var tenant = super.currentTenant();
        if (Boolean.TRUE.equals(basic.getEnabled()) && tenant != null) {
            var enabled = tenantUserRepoProc.getEnabled(tenant.getId(), basic.getId());
            if (enabled != null) {
                basic.setEnabled(enabled);
            }
        }
        return basic;
    }

    protected List<SysUserBasicDTO> fillTenantUser(List<SysUserBasicDTO> basicList) {
        if (CollUtil.isEmpty(basicList)) {
            return basicList;
        }
        // 启用状态
        var tenant = super.currentTenant();
        if (tenant != null) {
            var userIds = basicList.stream().map(SysUserBasicDTO::getId).collect(Collectors.toSet());
            var enabledMap = tenantUserRepoProc.getEnabled(tenant.getId(), userIds);
            for (SysUserBasicDTO basic : basicList) {
                basic.setEnabled(Boolean.TRUE.equals(basic.getEnabled()) && Boolean.TRUE.equals(enabledMap.get(basic.getId())));
            }
        }
        return basicList;
    }
}
