package com.elitescloud.cloudt.system.service.impl;

import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.cloudt.system.service.callback.UserChangedCallback;
import com.elitescloud.cloudt.system.service.manager.EmployeeMngManager;
import com.elitescloud.cloudt.system.service.model.bo.SysUserSaveBO;
import com.elitescloud.cloudt.system.service.model.entity.SysUserDO;
import com.elitescloud.cloudt.system.service.repo.EmployeeRepoProc;
import lombok.extern.slf4j.Slf4j;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;

import java.util.function.Supplier;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/11
 */
@Slf4j
@Service
public class UserChanedCallbackEmployeeServiceImpl implements UserChangedCallback {

    @Autowired
    private EmployeeRepoProc employeeRepoProc;
    @Autowired
    private EmployeeMngManager employeeMngManager;
    @Autowired
    private TenantDataIsolateProvider tenantDataIsolateProvider;
    @Autowired
    private TenantClientProvider tenantClientProvider;
    @Autowired
    private TaskExecutor taskExecutor;

    @Override
    public void onUpsert(boolean add, SysUserSaveBO saveBO, SysUserDO userDO) {
        this.detectTenant(() -> {
            employeeRepoProc.updateUserInfo(userDO);
            return null;
        });
    }

    @Override
    public void onEnabled(Long userId, boolean enabled) {
        this.detectTenant(() -> {
            employeeRepoProc.updateEnabledByUserId(userId, enabled);
            return null;
        });
    }

    @Override
    public void onUpdatePassword(Long userId, String password, String originalPassword) {

    }

    @Override
    public void onUpdateMobile(Long userId, String mobile) {

    }

    @Override
    public void onUpdateEmail(Long userId, String email) {

    }

    @Override
    public void onDelete(Long userId) {
        this.detectTenant(() -> {
            employeeMngManager.deleteEmployeeByUser(userId);
            return null;
        });
    }

    private void detectTenant(Supplier<Void> supplier) {
        var tenant = tenantClientProvider.getCurrentTenant();
        taskExecutor.execute(() -> {
            if (tenant == null) {
                tenantDataIsolateProvider.byAllTenant(supplier);
                return;
            }

            tenantDataIsolateProvider.byTenantDirectly(supplier, tenant);
        });
    }
}
