package com.elitescloud.cloudt.system.service.manager;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.cloudt.system.service.model.bo.AreaBO;
import com.elitescloud.cloudt.system.service.repo.AreaRepoProc;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/18
 */
@Component
public class AreaManager {

    @Autowired
    private AreaRepoProc repoProc;

    /**
     * 获取行政区域信息
     *
     * @param provinceCode
     * @param cityCode
     * @param countyCode
     * @return
     */
    public AreaBO getAreaBO(String provinceCode, String cityCode, String countyCode) {
        List<String> codes = new ArrayList<>(8);
        if (CharSequenceUtil.isNotBlank(provinceCode)) {
            codes.add(provinceCode);
        }
        if (CharSequenceUtil.isNotBlank(cityCode)) {
            codes.add(cityCode);
        }
        if (CharSequenceUtil.isNotBlank(countyCode)) {
            codes.add(countyCode);
        }
        if (codes.isEmpty()) {
            return null;
        }

        var codeNameMap = repoProc.getCodeAndName(codes);

        AreaBO areaBO = new AreaBO();
        areaBO.setProvinceCode(provinceCode);
        if (CharSequenceUtil.isNotBlank(provinceCode)) {
            areaBO.setProvinceName(codeNameMap.get(provinceCode));
        }
        areaBO.setCityCode(cityCode);
        if (CharSequenceUtil.isNotBlank(cityCode)) {
            areaBO.setCityName(codeNameMap.get(cityCode));
        }
        areaBO.setCountyCode(countyCode);
        if (CharSequenceUtil.isNotBlank(countyCode)) {
            areaBO.setCountyName(codeNameMap.get(countyCode));
        }

        return areaBO;
    }
}
