package com.elitescloud.cloudt.system.service.manager;

import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.dto.SysOuBasicDTO;
import com.elitescloud.cloudt.system.service.repo.OuRepoProc;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2/15/2023
 */
@Component
@TenantTransaction(isolateType = TenantIsolateType.TENANT)
public class OuQueryManager {

    @Autowired
    private OuRepoProc ouRepoProc;

    /**
     * 获取公司基本信息
     *
     * @param ouId 公司ID
     * @return 公司基本信息
     */
    public SysOuBasicDTO getOuBasicDTO(long ouId) {
        return ouRepoProc.getOuBasic(ouId);
    }
}
