package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.platform.model.constant.PlatformAdminTypeEnum;
import com.elitescloud.cloudt.platform.model.constant.PlatformMenusNodeEnum;
import com.elitescloud.cloudt.platform.model.entity.QSysPlatformAdminMenusDO;
import com.elitescloud.cloudt.platform.model.entity.QSysPlatformMenusDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformAdminMenusDO;
import com.elitescloud.cloudt.system.model.bo.PermissionMenuBO;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/10/20
 */
@Repository
public class AdminMenuRepoProc extends BaseRepoProc<SysPlatformAdminMenusDO> {
    private static final QSysPlatformAdminMenusDO QDO = QSysPlatformAdminMenusDO.sysPlatformAdminMenusDO;
    private static final QSysPlatformMenusDO QDO_MENU = QSysPlatformMenusDO.sysPlatformMenusDO;

    public AdminMenuRepoProc() {
        super(QDO);
    }

    /**
     * 获取管理员菜单
     *
     * @param adminType
     * @param appCode
     * @param includeAction
     * @return
     */
    public List<PermissionMenuBO> queryMenuOfTenantAdmin(Collection<PlatformAdminTypeEnum> adminType, Collection<String> appCode, boolean includeAction) {
        var predicate = PredicateBuilder.builder()
                .andIn(!CollectionUtils.isEmpty(adminType), QDO.adminType, adminType.stream().map(PlatformAdminTypeEnum::name).collect(Collectors.toSet()))
                .andEq(true, QDO_MENU.menusState, true)
                .andIn(!CollectionUtils.isEmpty(appCode), QDO_MENU.menusAppCode, appCode)
                .andIn(!includeAction, QDO_MENU.nodeType, Set.of(PlatformMenusNodeEnum.MENUS.name(), PlatformMenusNodeEnum.MENUS_GROUP.name()))
                .build();

        return jpaQueryFactory.select(qBeanPermissionMenu())
                .from(QDO)
                .leftJoin(QDO_MENU).on(QDO_MENU.menusCode.eq(QDO.menusCode))
                .where(predicate)
                .fetch();
    }

    private QBean<PermissionMenuBO> qBeanPermissionMenu() {
        return Projections.bean(PermissionMenuBO.class, QDO_MENU.menusAppCode, QDO_MENU.menusName, QDO_MENU.menusType, QDO_MENU.nodeType, QDO_MENU.menusCode,
                QDO_MENU.menusOrder, QDO_MENU.menusState,
                QDO_MENU.menusParentCode, QDO_MENU.menusRoute, QDO_MENU.menusIcon,
                QDO_MENU.display,QDO_MENU.outerLink,QDO_MENU.outerLinkType);
    }
}
