package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.model.entity.QSysAlertDO;
import com.elitescloud.cloudt.system.model.entity.SysAlertDO;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotBlank;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/26
 */
@Repository
public class AlertRepoProc extends BaseRepoProc<SysAlertDO> {
    private static final QSysAlertDO QDO = QSysAlertDO.sysAlertDO;

    public AlertRepoProc() {
        super(QDO);
    }

    /**
     * 判断是否存在
     *
     * @param businessType
     * @return
     */
    public boolean existsByBusinessType(@NotBlank String businessType) {
        return super.exists(QDO.businessType, businessType);
    }

    /**
     * 根据业务类型获取
     *
     * @param businessType
     * @return
     */
    public SysAlertDO getByBusinessType(@NotBlank String businessType) {
        return super.getOneByValue(QDO.businessType, businessType);
    }

}
