package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.platform.model.entity.QSysPlatformApiPermissionDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformApiPermissionDO;
import com.elitescloud.cloudt.system.provider.dto.SysApiPermissionMetadataDTO;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

import javax.validation.constraints.NotBlank;
import java.util.List;
import java.util.Set;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/10/17
 */
@Repository
public class ApiRepoProc extends BaseRepoProc<SysPlatformApiPermissionDO> {
    private static final QSysPlatformApiPermissionDO QDO = QSysPlatformApiPermissionDO.sysPlatformApiPermissionDO;

    public ApiRepoProc() {
        super(QDO);
    }

    /**
     * 根据编码获取接口
     *
     * @param code
     * @return
     */
    public SysPlatformApiPermissionDO getByCode(@NotBlank String code) {
        return super.getOneByValue(QDO.permissonCode, code);
    }

    /**
     * 根据应用编码获取API
     *
     * @param appCodes
     * @return
     */
    public List<SysPlatformApiPermissionDO> queryByAppCode(Set<String> appCodes) {
        Predicate predicate = CollectionUtils.isEmpty(appCodes) ? null : QDO.appCode.in(appCodes);
        return jpaQueryFactory.select(QDO)
                .from(QDO)
                .where(predicate)
                .fetch();
    }

    /**
     * 查询应用的权限数据
     *
     * @param appCode
     * @return
     */
    public List<SysApiPermissionMetadataDTO> queryPermissionMetadata(String appCode) {
        return jpaQueryFactory.select(Projections.bean(SysApiPermissionMetadataDTO.class, QDO.permissonPath.as("uri"), QDO.permissonCode.as("permissionCode"), QDO.requestType.as("method")))
                .from(QDO)
                .where(QDO.appCode.eq(appCode))
                .fetch();
    }
}
