package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.model.vo.query.org.EmpGroupPageQueryVO;
import com.elitescloud.cloudt.system.service.model.entity.QSysEmpGroupDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysEmpGroupEmpDO;
import com.elitescloud.cloudt.system.service.model.entity.SysEmpGroupDO;
import org.springframework.stereotype.Repository;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/2/2
 */
@Repository
public class EmpGroupRepoProc extends BaseRepoProc<SysEmpGroupDO> {
    private static final QSysEmpGroupDO QDO = QSysEmpGroupDO.sysEmpGroupDO;
    private static final QSysEmpGroupEmpDO QDO_GROUP_EMP = QSysEmpGroupEmpDO.sysEmpGroupEmpDO;

    public EmpGroupRepoProc() {
        super(QDO);
    }

    /**
     * 更新启用状态
     *
     * @param id      ID
     * @param enabled 启用状态
     */
    public void updateEnabled(long id, Boolean enabled) {
        super.updateValue(QDO.enabled, enabled, id);
    }

    /**
     * 判断编码是否已存在
     *
     * @param code 编码
     * @param id   ID
     * @return 是佛已存在
     */
    public boolean existsCode(String code, Long id) {
        return super.exists(QDO.code, code, id);
    }

    /**
     * 获取启用状态
     *
     * @param id id
     * @return 启用状态
     */
    public Boolean getEnabled(long id) {
        return super.getValue(QDO.enabled, id);
    }

    /**
     * 分页查询管理
     *
     * @param queryVO 查询参数
     * @return 员工组列表
     */
    public PagingVO<SysEmpGroupDO> pageMng(EmpGroupPageQueryVO queryVO) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.type, queryVO.getType())
                .andLike(QDO.code, queryVO.getCode())
                .andLike(QDO.name, queryVO.getName())
                .build();
        return super.queryByPage(predicate, queryVO.getPageRequest());
    }
}
