package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.common.OwnerType;
import com.elitescloud.cloudt.system.model.entity.QSysFrontTableCfgDO;
import com.elitescloud.cloudt.system.model.entity.SysFrontTableCfgDO;
import com.querydsl.core.Tuple;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/4/20
 */
@Repository
public class FrontTableCfgRepoProc extends BaseRepoProc<SysFrontTableCfgDO> {
    private static final QSysFrontTableCfgDO QDO = QSysFrontTableCfgDO.sysFrontTableCfgDO;

    public FrontTableCfgRepoProc() {
        super(QDO);
    }

    /**
     * 更新配置内容
     *
     * @param id     配置ID
     * @param config 配置内容
     */
    public void updateConfig(long id, String config) {
        super.updateValue(QDO.config, config, id);
    }

    /**
     * 获取表格的配置ID
     *
     * @param ownerId   拥有者ID
     * @param ownerType 拥有者类型
     * @param tableCode 表格编码
     * @return 配置ID
     */
    public Long getId(long ownerId, @NotNull OwnerType ownerType, @NotBlank String tableCode) {
        return jpaQueryFactory.select(QDO.id)
                .from(QDO)
                .where(QDO.ownerId.eq(ownerId).and(QDO.tableCode.eq(tableCode)).and(QDO.ownerType.eq(ownerType)))
                .limit(1)
                .fetchOne();
    }

    /**
     * 获取表格的配置ID
     *
     * @param ownerId   拥有者ID
     * @param ownerType 拥有者类型
     * @param tableCode 表格编码
     * @return 配置ID
     */
    public SysFrontTableCfgDO get(long ownerId, @NotNull OwnerType ownerType, @NotBlank String tableCode) {
        return jpaQueryFactory.selectFrom(QDO)
                .where(QDO.ownerId.eq(ownerId).and(QDO.tableCode.eq(tableCode)).and(QDO.ownerType.eq(ownerType)))
                .limit(1)
                .fetchOne();
    }

    /**
     * 查询用户配置
     *
     * @param ownerIds  拥有者ID集合
     * @param tableCode 表格编码
     * @return 配置
     */
    public Map<OwnerType, String> queryUserConfig(@NotEmpty Collection<Long> ownerIds, @NotBlank String tableCode) {
        var cfgList = jpaQueryFactory.select(QDO.ownerType, QDO.config)
                .from(QDO)
                .where(QDO.ownerId.in(ownerIds).and(QDO.tableCode.eq(tableCode)))
                .fetch();
        Map<OwnerType, String> cfgMap = new HashMap<>(4);
        for (Tuple tuple : cfgList) {
            cfgMap.put(tuple.get(QDO.ownerType), tuple.get(QDO.config));
        }
        return cfgMap;
    }
}
