package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.model.entity.QSysMqRetryDO;
import com.elitescloud.cloudt.system.model.entity.SysMqRetryDO;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.JPAExpressions;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/8/30
 */
@Repository
public class MqMessageRetryRepoProc extends BaseRepoProc<SysMqRetryDO> {
    private static final QSysMqRetryDO QDO = QSysMqRetryDO.sysMqRetryDO;

    public MqMessageRetryRepoProc() {
        super(QDO);
    }

    /**
     * 根据消息ID删除重试记录
     *
     * @param messageId
     */
    public void deleteRetryByMessageId(@NotBlank String messageId, Boolean consumer) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.messageId, messageId)
                .andEq(QDO.consumer, consumer)
                .build();
        jpaQueryFactory.delete(QDO)
                .where(predicate)
                .execute();
    }

    /**
     * 根据消息ID删除重试记录
     *
     * @param messageId
     */
    public void deleteRetryByMessageId(@NotBlank String messageId) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.messageId, messageId)
                .build();
        jpaQueryFactory.delete(QDO)
                .where(predicate)
                .execute();
    }

    /**
     * 根据消息ID获取记录
     *
     * @param messageId
     * @return
     */
    public SysMqRetryDO getByMessageId(@NotBlank String messageId, Boolean consumer) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.messageId, messageId)
                .andEq(QDO.consumer, consumer)
                .build();

        return super.jpaQueryFactory.selectFrom(QDO)
                .where(predicate)
                .limit(1)
                .fetchOne();
    }

    /**
     * 获取版本号
     *
     * @param messageId
     * @return
     */
    public Integer getVersionByMessageId(@NotBlank String messageId) {
        return super.getValueByValue(QDO.auditDataVersion, QDO.messageId, messageId);
    }

    /**
     * 查询待重试的消息
     *
     * @param lastMessageId
     * @param size
     * @return
     */
    public List<SysMqRetryDO> queryRetry(String lastMessageId, int size) {
        QSysMqRetryDO qdoSub = new QSysMqRetryDO("sub");
        return jpaQueryFactory.selectFrom(QDO)
                .where(StringUtils.hasText(lastMessageId) ? QDO.sendTimeNext.after(JPAExpressions.select(qdoSub.sendTimeNext).from(qdoSub).where(qdoSub.messageId.eq(lastMessageId))) : null)
                .orderBy(QDO.sendTimeNext.asc())
                .limit(size)
                .fetch();
    }
}
