package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.model.entity.QSysResourceByteDO;
import com.elitescloud.cloudt.system.model.entity.SysResourceByteDO;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/25
 */
@Repository
public class ResourceByteRepoProc extends BaseRepoProc<SysResourceByteDO> {
    private static final QSysResourceByteDO QDO = QSysResourceByteDO.sysResourceByteDO;

    public ResourceByteRepoProc() {
        super(QDO);
    }

    /**
     * 更新临时标识
     *
     * @param resourceKey
     * @param temp
     */
    public void updateTemp(@NotBlank String resourceKey, boolean temp) {
        super.updateValueByValue(QDO.temp, temp, QDO.resourceKey, resourceKey);
    }

    /**
     * 根据文件标识删除
     *
     * @param resourceKey
     */
    public void deleteByResourceKey(@NotBlank String resourceKey) {
        super.deleteByValue(QDO.resourceKey, resourceKey);
    }

    /**
     * 获取资源文件
     *
     * @param resourceKey
     * @return
     */
    public SysResourceByteDO getByResourceKey(@NotBlank String resourceKey) {
        return super.getOneByValue(QDO.resourceKey, resourceKey);
    }

    /**
     * 获取资源文件内容
     *
     * @param resourceKey
     * @return
     */
    public byte[] getResourceByResourceKey(@NotBlank String resourceKey) {
        return super.getValueByValue(QDO.resource, QDO.resourceKey, resourceKey);
    }

    /**
     * 获取过期的文件
     *
     * @param expiredTime
     * @param size
     * @return
     */
    public List<SysResourceByteDO> queryExpiredTempResource(LocalDateTime expiredTime, int size) {
        return super.jpaQueryFactory.selectFrom(QDO)
                .where(QDO.createTime.before(expiredTime).and(QDO.temp.eq(true)))
                .limit(size)
                .fetch();
    }
}
