package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.role.RoleGroupPageQueryVO;
import com.elitescloud.cloudt.system.service.model.entity.QSysRoleGroupDO;
import com.elitescloud.cloudt.system.service.model.entity.SysRoleGroupDO;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.StringExpression;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotBlank;
import java.util.Collection;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/11/24
 */
@Repository
public class RoleGroupRepoProc extends BaseRepoProc<SysRoleGroupDO> {
    private static final QSysRoleGroupDO QDO = QSysRoleGroupDO.sysRoleGroupDO;

    public RoleGroupRepoProc() {
        super(QDO);
    }

    /**
     * 更新启用标识
     *
     * @param id
     * @param enabled
     */
    public void updateEnabled(long id, boolean enabled) {
        super.updateValue(QDO.enabled, enabled, id);
    }

    /**
     * 是否编码已存在
     *
     * @param groupCode
     * @return
     */
    public boolean existsCode(@NotBlank String groupCode) {
        return super.exists(QDO.groupCode, groupCode);
    }

    /**
     * 获取分组名称
     *
     * @param id
     * @return
     */
    public String getName(long id) {
        return super.getValue(QDO.groupName, id);
    }

    /**
     * 分页查询管理
     *
     * @param queryVO
     * @return
     */
    public PagingVO<SysRoleGroupDO> pageMng(RoleGroupPageQueryVO queryVO) {
        var predicate = PredicateBuilder.builder()
                .andLike(QDO.groupCode, queryVO.getGroupCode())
                .andLike(QDO.groupName, queryVO.getGroupName())
                .andEq(QDO.enabled, queryVO.getEnabled())
                .andLike(new StringExpression[]{QDO.groupCode, QDO.groupName}, queryVO.getKeyword())
                .build();

        return super.queryByPage(predicate, queryVO.getPageRequest(), QDO.createTime.desc());
    }

    /**
     * 查询角色组列表
     *
     * @return
     */
    public List<IdCodeNameParam> list() {
        return super.jpaQueryFactory.select(qBeanIdCodeName())
                .from(QDO)
                .where(QDO.enabled.eq(true))
                .orderBy(QDO.createTime.desc())
                .fetch();
    }

    /**
     * 根据ID查询
     *
     * @param ids
     * @return
     */
    public List<IdCodeNameParam> queryByList(Collection<Long> ids) {
        return super.jpaQueryFactory.select(qBeanIdCodeName())
                .from(QDO)
                .where(QDO.id.in(ids))
                .fetch();
    }

    private QBean<IdCodeNameParam> qBeanIdCodeName() {
        return Projections.bean(IdCodeNameParam.class, QDO.id, QDO.groupCode.as("code"), QDO.groupName.as("name"));
    }
}
