package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.model.bo.PermissionParameterBO;
import com.elitescloud.cloudt.system.service.model.entity.QSysDpcrApiFieldsDO;
import com.elitescloud.cloudt.system.service.model.entity.SysDpcrApiFieldsDO;
import com.elitescloud.cloudt.system.service.model.entity.SysDprRoleApiRowRuleDO;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.Collection;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 3/29/2023
 */
@Repository
public class SysDpcrApiFieldsRepoProc extends BaseRepoProc<SysDpcrApiFieldsDO> {
    private static final QSysDpcrApiFieldsDO QDO = QSysDpcrApiFieldsDO.sysDpcrApiFieldsDO;

    public SysDpcrApiFieldsRepoProc() {
        super(QDO);
    }

    /**
     * 获取字段
     *
     * @param roleId   角色ID
     * @param menuCode 菜单编码
     * @param apiCode  api编码
     * @return 规则列表
     */
    public List<PermissionParameterBO> queryByApi(long roleId, @NotBlank String menuCode, @NotBlank String apiCode) {
        return super.jpaQueryFactory.select(qBeanPermissionParameterBO())
                .from(QDO)
                .where(QDO.roleId.eq(roleId).and(QDO.apiCode.eq(apiCode)).and(QDO.menuCode.eq(menuCode)))
                .fetch();
    }

    /**
     * 删除字段
     *
     * @param roleId   角色ID
     * @param menuCode 菜单编码
     * @param apiCode  api编码
     */
    public void deleteByApi(long roleId, @NotBlank String menuCode, @NotBlank String apiCode) {
        super.jpaQueryFactory.delete(QDO)
                .where(QDO.roleId.eq(roleId).and(QDO.menuCode.eq(menuCode)).and(QDO.apiCode.eq(apiCode)))
                .execute();
    }

    /**
     * 删除菜单下已不存在的api
     *
     * @param menuCode 菜单编码
     * @param apiCodes api编码
     */
    public void deleteForNotExistsApi(@NotBlank String menuCode, @NotEmpty Collection<String> apiCodes) {
        super.jpaQueryFactory.delete(QDO)
                .where(QDO.menuCode.eq(menuCode).and(QDO.apiCode.notIn(apiCodes)))
                .execute();
    }

    /**
     * 根据角色删除
     *
     * @param roleId
     */
    public void deleteByRole(long roleId) {
        super.deleteByValue(QDO.roleId, roleId);
    }

    /**
     * 根据角色查询
     *
     * @param roleId
     * @return
     */
    public List<SysDpcrApiFieldsDO> listByRole(long roleId) {
        return super.getListByValue(QDO.roleId, roleId);
    }

    /**
     * 查询角色分配的权限字段
     *
     * @param roleIds  角色ID
     * @param menuCode 菜单编码
     * @param apiCode  API接口编码
     * @return 字段列表
     */
    public List<PermissionParameterBO> queryBoByRole(@NotEmpty Collection<Long> roleIds, @NotBlank String menuCode, @NotBlank String apiCode) {
        return super.jpaQueryFactory.select(qBeanPermissionParameterBO())
                .from(QDO)
                .where(QDO.roleId.in(roleIds).and(QDO.apiCode.eq(apiCode)).and(QDO.menuCode.eq(menuCode)))
                .fetch();
    }

    private QBean<PermissionParameterBO> qBeanPermissionParameterBO() {
        return Projections.bean(PermissionParameterBO.class, QDO.id, QDO.roleId, QDO.menuCode, QDO.apiCode, QDO.fieldName,
                QDO.fieldApiVisible, QDO.fieldFormVisible, QDO.fieldFormUpdate);
    }
}
