package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.model.entity.QSysSettingDO;
import com.elitescloud.cloudt.system.model.entity.SysSettingDO;
import com.elitescloud.cloudt.system.param.SysSettingQParam;
import com.elitescloud.cloudt.system.service.dto.SysSettingDTO;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.EntityPathBase;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author Chris
 * 2021-08-31
 */
@Repository
public class SysSettingRepoProc extends BaseRepoProc<SysSettingDO> {
    private static final QSysSettingDO QDO = QSysSettingDO.sysSettingDO;

    public SysSettingRepoProc() {
        super(QDO);
    }

    /**
     * 获取配置 dto
     *
     * @param settingNo 配置编号
     * @return dto
     */
    public List<SysSettingDTO> findDtosBySettingNo(String settingNo) {
        return jpaQueryFactory
                .select(Projections.bean(
                        SysSettingDTO.class,
                        QDO.id,
                        QDO.settingNo,
                        QDO.settingName,
                        QDO.settingType,
                        QDO.settingType2,
                        QDO.settingStatus,
                        QDO.settingDesc,
                        QDO.settingVal,
                        QDO.defaultValue,
                        QDO.sortNo
                ))
                .from(QDO)
                .where(
                        QDO.settingNo.eq(settingNo)
                                .and(QDO.deleteFlag.isNull().or(QDO.deleteFlag.eq(0)))
                )
                .fetch();
    }

    /**
     * 分页查询设置
     *
     * @param param 查询参数
     * @return 设置列表
     */
    public PagingVO<SysSettingDO> pageMng(SysSettingQParam param) {
        var predicate = PredicateBuilder.builder()
                .andRightLike(QDO.settingNo, param.getSettingNo())
                .andLike(QDO.settingName, param.getSettingName())
                .andEq(QDO.settingType, param.getSettingType())
                .andEq(QDO.settingType2, param.getSettingType2())
                .andEq(QDO.email, param.getEmail())
                .andEq(QDO.settingStatus, param.getSettingStatus())
                .andLike(QDO.settingDesc, param.getSettingDesc())
                .andEq(QDO.settingVal, param.getSettingVal())
                .andEq(QDO.defaultValue, param.getDefaultValue())
                .build();
        return super.queryByPage(predicate, param.getPageRequest(), QDO.createTime.desc());
    }
}
