package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.model.entity.QSysUserCompanyDO;
import com.elitescloud.cloudt.system.model.entity.SysUserCompanyDO;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Set;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/5/9
 */
@Repository
public class SysUserCompanyRepoProc extends BaseRepoProc<SysUserCompanyDO> {

    private static final QSysUserCompanyDO QDO = QSysUserCompanyDO.sysUserCompanyDO;

    public SysUserCompanyRepoProc() {
        super(QDO);
    }

    public void deleteByUserId(Long sysUserId) {
        jpaQueryFactory.delete(QDO)
                .where(QDO.sysUserId.eq(sysUserId))
                .execute();
    }

    public List<Long> getOuIdOfUser(Long sysUserId) {
        return jpaQueryFactory.select(QDO.ouId)
                .from(QDO)
                .where(QDO.sysUserId.eq(sysUserId))
                .fetch();
    }

    public List<SysUserCompanyDO> queryByUserIds(Set<Long> userIds) {
        return jpaQueryFactory.select(QDO)
                .from(QDO)
                .where(QDO.sysUserId.in(userIds))
                .fetch();
    }

    public SysUserCompanyDO queryByUserId(Long userId) {
        return jpaQueryFactory.select(QDO)
                .from(QDO)
                .where(QDO.sysUserId.eq(userId))
                .limit(1)
                .fetchOne();
    }
}
