package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.cloudt.system.service.param.SysWatermarkConfigQueryParam;
import com.elitescloud.cloudt.system.service.vo.SysWatermarkConfigVO;
import com.elitescloud.cloudt.system.model.entity.QSysWatermarkConfigDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import lombok.val;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author roman.zhang
 * @since 2022-03-25 15:17:52
 */
@Component
@RequiredArgsConstructor
public class SysWatermarkConfigRepoProc {

     private final JPAQueryFactory jpaQueryFactory;

    /**
     * 查询字段
     *
     */ 
    public  JPAQuery<SysWatermarkConfigVO> select(SysWatermarkConfigQueryParam param){
        QSysWatermarkConfigDO jpaQDo = QSysWatermarkConfigDO.sysWatermarkConfigDO;
        Predicate predicate = jpaQDo.isNotNull();
        JPAQuery<SysWatermarkConfigVO> jpaQuery=jpaQueryFactory.select(Projections.bean(SysWatermarkConfigVO.class,
                                jpaQDo.id,                
                                jpaQDo.dynamicFont,
                                jpaQDo.customField,                
                                jpaQDo.fontSize,                
                                jpaQDo.fontColor,                
                                jpaQDo.rotate,                
                                jpaQDo.stackingDeep,                
                                jpaQDo.tenantId,                
                                jpaQDo.remark,                
                                jpaQDo.createUserId,                
                                jpaQDo.creator,                
                                jpaQDo.createTime,                
                                jpaQDo.modifyUserId,                
                                jpaQDo.updater,                
                                jpaQDo.modifyTime,                
                                jpaQDo.deleteFlag,                
                                jpaQDo.auditDataVersion,                
                                jpaQDo.secBuId,                
                                jpaQDo.secUserId,                
                                jpaQDo.secOuId                
                                )).from(jpaQDo);
        if(param != null){
           jpaQuery.where(where(param));
        }
        jpaQuery.where(predicate,jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        return jpaQuery;
    }
     /**
     * 根据主键查询
     *
     * @param  id 主键
     */ 
    public Predicate where(Long id) {
        val jpaQDo = QSysWatermarkConfigDO.sysWatermarkConfigDO;
                Predicate predicate = jpaQDo.isNotNull().or(jpaQDo.isNull());
        ExpressionUtils.and(predicate, jpaQDo.id.eq(id));
        return predicate;
    }
   /**
     * 条件查询
     *
     * @param  param 查询条件
     */ 
    public Predicate where(SysWatermarkConfigQueryParam param) {
        val jpaQDo = QSysWatermarkConfigDO.sysWatermarkConfigDO;
                Predicate predicate = jpaQDo.isNotNull().or(jpaQDo.isNull());
                   if (!StringUtils.isEmpty(param.getId())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.id.eq(param.getId()));
          }
                   if (!StringUtils.isEmpty(param.getCustomField())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.customField.eq(param.getCustomField()));
          }
                   if (!StringUtils.isEmpty(param.getFontSize())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.fontSize.eq(param.getFontSize()));
          }
                   if (!StringUtils.isEmpty(param.getFontColor())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.fontColor.eq(param.getFontColor()));
          }
                   if (!StringUtils.isEmpty(param.getRotate())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.rotate.eq(param.getRotate()));
          }
                   if (!StringUtils.isEmpty(param.getStackingDeep())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.stackingDeep.eq(param.getStackingDeep()));
          }
                   if (!StringUtils.isEmpty(param.getTenantId())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.tenantId.eq(param.getTenantId()));
          }
                   if (!StringUtils.isEmpty(param.getRemark())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.remark.eq(param.getRemark()));
          }
                   if (!StringUtils.isEmpty(param.getCreateUserId())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.createUserId.eq(param.getCreateUserId()));
          }
                   if (!StringUtils.isEmpty(param.getCreator())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.creator.eq(param.getCreator()));
          }
                   if (!StringUtils.isEmpty(param.getModifyUserId())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.modifyUserId.eq(param.getModifyUserId()));
          }
                   if (!StringUtils.isEmpty(param.getUpdater())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.updater.eq(param.getUpdater()));
          }
                   if (!StringUtils.isEmpty(param.getDeleteFlag())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.deleteFlag.eq(param.getDeleteFlag()));
          }
                   if (!StringUtils.isEmpty(param.getAuditDataVersion())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.auditDataVersion.eq(param.getAuditDataVersion()));
          }
                   if (!StringUtils.isEmpty(param.getSecBuId())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.secBuId.eq(param.getSecBuId()));
          }
                   if (!StringUtils.isEmpty(param.getSecUserId())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.secUserId.eq(param.getSecUserId()));
          }
                   if (!StringUtils.isEmpty(param.getSecOuId())) {
          predicate = ExpressionUtils.and(predicate, jpaQDo.secOuId.eq(param.getSecOuId()));
          }
                  return predicate;
    }
}

