package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.service.model.entity.QSysTenantAppDO;
import com.elitescloud.cloudt.system.service.model.entity.SysTenantAppDO;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/9/20
 */
@Repository
public class TenantAppRepoProc extends BaseRepoProc<SysTenantAppDO> {
    private static final QSysTenantAppDO QDO = QSysTenantAppDO.sysTenantAppDO;

    public TenantAppRepoProc() {
        super(QDO);
    }

    public void deleteByTenantAndAppCode(Long sysTenantId, Set<String> appCodes) {
        jpaQueryFactory.delete(QDO)
                .where(QDO.sysTenantId.eq(sysTenantId).and(QDO.appCode.in(appCodes)))
                .execute();
    }

    public Set<String> getAppCode(Long sysTenantId) {
        return new HashSet<>(jpaQueryFactory.select(QDO.appCode)
                .from(QDO)
                .where(QDO.sysTenantId.eq(sysTenantId))
                .fetch());
    }

    public Map<Long, Set<String>> getAppCodes(Collection<Long> tenantIds) {
        return jpaQueryFactory.select(QDO.sysTenantId, QDO.appCode)
                .from(QDO)
                .where(CollectionUtils.isEmpty(tenantIds) ? null : QDO.sysTenantId.in(tenantIds))
                .fetch()
                .stream()
                .collect(Collectors.groupingBy(t -> t.get(QDO.sysTenantId),
                        Collectors.collectingAndThen(Collectors.toList(),
                                t -> t.stream().map(tt -> tt.get(QDO.appCode)).collect(Collectors.toSet()))));
    }

    public Map<Long, Set<String>> getAppCodeAll() {
        return jpaQueryFactory.select(QDO.sysTenantId, QDO.appCode)
                .from(QDO)
                .fetch()
                .stream()
                .collect(Collectors.groupingBy(t -> t.get(QDO.sysTenantId),
                        Collectors.collectingAndThen(Collectors.toList(),
                                t -> t.stream().map(tt -> tt.get(QDO.appCode)).collect(Collectors.toSet()))));
    }
}
