package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.service.model.entity.QSysTenantAreaDO;
import com.elitescloud.cloudt.system.service.model.entity.SysTenantAreaDO;
import org.springframework.stereotype.Repository;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/1/30
 */
@Repository
public class TenantAreaRepoProc extends BaseRepoProc<SysTenantAreaDO> {
    private static final QSysTenantAreaDO QDO = QSysTenantAreaDO.sysTenantAreaDO;

    public TenantAreaRepoProc() {
        super(QDO);
    }

    /**
     * 更新是否启用
     *
     * @param sysTenantId
     * @param enabled
     */
    public void updateEnabled(long sysTenantId, Boolean enabled) {
        super.updateValueByValue(QDO.enabled, enabled, QDO.sysTenantId, sysTenantId);
    }

    /**
     * 获取是否启用
     *
     * @param sysTenantId
     * @return
     */
    public Boolean getEnabled(long sysTenantId) {
        return super.getValueByValue(QDO.enabled, QDO.sysTenantId, sysTenantId);
    }
}
