package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.service.model.entity.QSysTenantMenuDO;
import com.elitescloud.cloudt.system.service.model.entity.SysTenantMenuDO;
import org.springframework.stereotype.Repository;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/10/13
 */
@Repository
public class TenantMenuRepoProc extends BaseRepoProc<SysTenantMenuDO> {
    private static final QSysTenantMenuDO QDO = QSysTenantMenuDO.sysTenantMenuDO;

    public TenantMenuRepoProc() {
        super(QDO);
    }

    /**
     * 更新启用状态
     *
     * @param id
     * @param enabled
     */
    public void updateEnabled(Long id, Boolean enabled) {
        super.updateValue(QDO.enabled, enabled, id);
    }

    /**
     * 获取租户的自定义菜单启用状态
     *
     * @param tenantId
     * @return
     */
    public Boolean getEnabled(Long tenantId) {
        return jpaQueryFactory.select(QDO.enabled)
                .from(QDO)
                .where(QDO.sysTenantId.eq(tenantId))
                .limit(1)
                .fetchOne();
    }

    /**
     * 根据租户ID获取
     *
     * @param tenantId
     * @return
     */
    public SysTenantMenuDO getByTenantId(Long tenantId) {
        return super.getOneByValue(QDO.sysTenantId, tenantId);
    }
}
