package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.service.model.entity.QSysTenantMenuTreeDO;
import com.elitescloud.cloudt.system.service.model.entity.SysTenantMenuTreeDO;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/10/14
 */
@Repository
public class TenantMenuTreeRepoProc extends BaseRepoProc<SysTenantMenuTreeDO> {
    private static final QSysTenantMenuTreeDO QDO = QSysTenantMenuTreeDO.sysTenantMenuTreeDO;

    public TenantMenuTreeRepoProc() {
        super(QDO);
    }

    /**
     * 租户ID
     *
     * @param tenantId 租户ID
     */
    public void deleteByTenantId(Long tenantId) {
        super.deleteByValue(QDO.sysTenantId, tenantId);
    }

    /**
     * 根据菜单名称模糊查询菜单编码
     *
     * @param menuNameLike
     * @return
     */
    public List<String> queryMenuCodeByMenuNameLike(@NotBlank String menuNameLike, @NotNull Long tenantId) {
        return jpaQueryFactory.select(QDO.menuCode)
                .from(QDO)
                .where(QDO.sysTenantId.eq(tenantId).and(QDO.menuName.like("%" + menuNameLike + "%")))
                .fetch();
    }

    /**
     * 根据菜单编码获取菜单名称
     *
     * @param menuCodes
     * @return
     */
    public Map<String, String> getMenuNameByMenuCode(@NotEmpty Collection<String> menuCodes) {
        return jpaQueryFactory.select(QDO.menuName, QDO.menuCode)
                .from(QDO)
                .where(QDO.menuCode.in(menuCodes))
                .fetch()
                .stream()
                .collect(Collectors.toMap(t -> t.get(QDO.menuCode), t -> t.get(QDO.menuName), (t1, t2) -> t1));
    }

    /**
     * 根据租户查询菜单
     *
     * @param tenantId 租户ID
     * @return
     */
    public List<SysTenantMenuTreeDO> queryByTenantId(@NotNull Long tenantId) {
        return jpaQueryFactory.select(QDO)
                .from(QDO)
                .where(QDO.sysTenantId.eq(tenantId))
                .fetch();
    }

    /**
     * 根据菜单编码获取
     *
     * @param menuCode
     * @param tenantId
     * @return
     */
    public SysTenantMenuTreeDO getByMenuCode(@NotBlank String menuCode, @NotNull Long tenantId) {
        return jpaQueryFactory.select(QDO)
                .from(QDO)
                .where(QDO.menuCode.eq(menuCode).and(QDO.sysTenantId.eq(tenantId)))
                .limit(1)
                .fetchOne();
    }
}
