package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.model.entity.QSysThirdApiBusinessDO;
import com.elitescloud.cloudt.system.model.entity.SysThirdApiBusinessDO;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotBlank;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/20
 */
@Repository
public class ThirdApiBusinessRepoProc extends BaseRepoProc<SysThirdApiBusinessDO> {
    private static final QSysThirdApiBusinessDO QDO = QSysThirdApiBusinessDO.sysThirdApiBusinessDO;

    public ThirdApiBusinessRepoProc() {
        super(QDO);
    }

    /**
     * 更新成功标识
     *
     * @param id
     * @param success
     */
    public void updateSuccess(long id, boolean success) {
        super.updateValue(QDO.success, success, id);
    }

    /**
     * 更新成功标识
     *
     * @param businessType
     * @param businessKey
     * @param success
     */
    public void updateSuccess(@NotBlank String businessType, @NotBlank String businessKey, boolean success) {
        super.jpaQueryFactory.update(QDO)
                .set(QDO.success, success)
                .where(QDO.businessKey.eq(businessKey).and(QDO.businessType.eq(businessKey)))
                .execute();
    }

    /**
     * 是否已存在
     *
     * @param businessType
     * @param businessKey
     * @return
     */
    public Long getId(@NotBlank String businessType, @NotBlank String businessKey) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.businessKey, businessKey)
                .andEq(QDO.businessType, businessType)
                .build();
        return super.jpaQueryFactory.select(QDO.id)
                .from(QDO)
                .where(predicate)
                .limit(1)
                .fetchOne();
    }

    /**
     * 获取成功标识
     *
     * @param businessType
     * @param businessKey
     * @return
     */
    public Boolean getSuccess(@NotBlank String businessType, @NotBlank String businessKey) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.businessKey, businessKey)
                .andEq(QDO.businessType, businessType)
                .build();

        return super.jpaQueryFactory.select(QDO.success)
                .from(QDO)
                .where(predicate)
                .limit(1)
                .fetchOne();
    }
}
