package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.model.entity.QSysThirdApiLogDO;
import com.elitescloud.cloudt.system.model.entity.QSysThirdApiRetryDO;
import com.elitescloud.cloudt.system.model.entity.SysThirdApiRetryDO;
import com.querydsl.jpa.JPAExpressions;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/13
 */
@Repository
public class ThirdApiRetryRepoProc extends BaseRepoProc<SysThirdApiRetryDO> {
    private static final QSysThirdApiRetryDO QDO = QSysThirdApiRetryDO.sysThirdApiRetryDO;
    private static final QSysThirdApiLogDO QDO_LOG = QSysThirdApiLogDO.sysThirdApiLogDO;

    public ThirdApiRetryRepoProc() {
        super(QDO);
    }

    /**
     * 删除重试记录
     *
     * @param logId
     */
    public void deleteByLogId(long logId) {
        super.deleteByValue(QDO.recordLogId, logId);
    }

    /**
     * 根据日志记录获取
     *
     * @param logId
     * @return
     */
    public SysThirdApiRetryDO getByRecordLogId(long logId) {
        return super.getOneByValue(QDO.recordLogId, logId);
    }

    /**
     * 查询需要重试的
     *
     * @param lastLogId
     * @param size
     * @return
     */
    public List<SysThirdApiRetryDO> listToRetry(Long lastLogId, int size) {
        if (lastLogId == null) {
            return super.jpaQueryFactory.selectFrom(QDO)
                    .orderBy(QDO.createTime.asc()).limit(size)
                    .fetch();
        }
        var originalId = super.jpaQueryFactory.select(QDO_LOG.originalId)
                .from(QDO_LOG)
                .where(QDO_LOG.id.eq(lastLogId))
                .limit(1)
                .fetchOne();
        return super.jpaQueryFactory.selectFrom(QDO)
                .where(QDO.createTime.after(
                        JPAExpressions.select(QDO.createTime).from(QDO).where(QDO.recordLogId.eq(originalId))
                )).orderBy(QDO.createTime.asc()).limit(size)
                .fetch();
    }

    /**
     * 获取版本号
     *
     * @param lastLogId
     * @return
     */
    public Integer getVersionByLastLogId(long lastLogId) {
        return super.getValueByValue(QDO.auditDataVersion, QDO.recordLogId, lastLogId);
    }
}
