package com.elitescloud.cloudt.system.service.repo.old;

import com.elitescloud.cloudt.system.service.model.entity.SysUserDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Optional;

/**
 * <pre>
 * 系统用户账号表JPA+QueryDSL访问封装
 * </pre>
 *
 * @author Michael Li
 * 2020/6/15
 */
@Repository
public interface SysUserRepo extends JpaRepository<SysUserDO, Long>, QuerydslPredicateExecutor<SysUserDO> {



    List<SysUserDO> findAllByIdIn(List<Long> ids);

    /**
     * 根据用户名查询用户
     * @param username 用户名
     * @return optional
     */
    Optional<SysUserDO> findByUsername(String username);

    /**
     * 微信wxOpenid查询账号信息
     * **/
//    List<SysUserDO> findByWxOpenid(String openid);
    List<SysUserDO> findByMobile(String mobile);
    List<SysUserDO> findByMobileAndPassword(String mobile,String password);

    /**
     * 批量删除
     * @param ids ids
     */
    void deleteAllByIdIn(List<Long> ids);

    /**
     * 是否存在相同用户名
     * @param username 用户名
     * @return boolean
     */
    boolean existsByUsername(String username);

    /**
     * 是否存在相同电话号码
     * @param mobile 电话号码
     * @return boolean
     */
    boolean existsByMobile(String mobile);

    /**
     * 除自己以外，是否存在相同电话号码
     * @param mobile 电话号码
     * @param id id
     * @return boolean
     */
    boolean existsByMobileAndIdNot(String mobile, Long id);

    /**
     * 是否存在相同邮箱地址
     * @param email 邮箱地址
     * @return boolean
     */
    boolean existsByEmail(String email);

    /**
     * 除自己以外，是否存在相同邮箱地址
     * @param email 邮箱地址
     * @param id id
     * @return boolean
     */
    boolean existsByEmailAndIdNot(String email, Long id);
}
