package com.elitescloud.cloudt.system.util;

import org.apache.commons.lang3.StringUtils;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

/**
 * @author caspar.chen
 * 2017-2-13
 */
public class BeanUtil {

    public final static String FORMAT_CST = "EEE MMM dd HH:mm:ss Z yyyy";

    public final static String FORMAT_YYYY_MM_DD_HHMMSS = "yyyy-MM-dd HH:mm:ss";
	/**
	 * 将object对象转换为map<String,String>
	 * 
	 * @param obj
	 * @return
	 */
	public static Map<String, String> ConvertObjToMapString(Object obj) {
		if(obj == null){  
            return null;  
        }
        Map<String, String> map = new HashMap<String, String>();  
        try {  
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());  
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();  
            for (PropertyDescriptor property : propertyDescriptors) {  
                String key = property.getName();
                String type = property.getPropertyType().getName();
                // 过滤class属性  
                if (!key.equals("class")) {  
                    // 得到property对应的getter方法  
                    Method getter = property.getReadMethod();  
                    Object value = getter.invoke(obj);  
                    if(value!=null){
                    	String v = value.toString();
                    	switch (type) {
						case "java.util.Date":
							//v = //DateUtil.convertToYYYY_MM_DD_HHMMSS(DateUtil.paserCSTToDate(v));
                            v= convertToString(paserCSTToDate(v),FORMAT_YYYY_MM_DD_HHMMSS);
							break;
						default:
							break;
						}
                    	map.put(key, v);
                    }
                }  
            }  
        } catch (Exception e) {  
            e.printStackTrace();
        }  
        return map;  
	}
	
	/**
	 * 将对象转为Map<String, Object>
	 * @param obj
	 * @return
	 */
    public static Map<String, Object> ConvertObjToMap(Object obj) {  
        if(obj == null){  
            return null;  
        }          
        Map<String, Object> map = new HashMap<String, Object>();  
        try {  
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());  
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();  
            for (PropertyDescriptor property : propertyDescriptors) {  
                String key = property.getName();  
                // 过滤class属性  
                if (!key.equals("class")) {  
                    // 得到property对应的getter方法  
                    Method getter = property.getReadMethod();  
                    Object value = getter.invoke(obj);  
                    if(value!=null){
                    	map.put(key, value);
                    }
                }  
            }  
        } catch (Exception e) {  
            e.printStackTrace();
        }  
        return map;  
    }

    public static Date paserCSTToDate(String strDate) throws ParseException {
        if (StringUtils.isEmpty(strDate)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_CST, Locale.UK);
        Date date = null;
        date = sdf.parse(strDate);
        return date;
    }

    public static String convertToString(Date date, String str) {
        if (StringUtils.isEmpty(str)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(str);
        return sdf.format(date);
    }
}
