package com.elitescloud.cloudt.ucenter.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 网站栏目信息表
 *
 * @author chaofeng.xia
 * @date 2023/5/23 15:21
 */
@Data
@ApiModel(description = "网站栏目信息表")
public class PcBarDTO implements Serializable {

    private static final long serialVersionUID = 1109608191069609670L;

    @ApiModelProperty(value = "栏目名称")
    private String name;

    @ApiModelProperty(value = "栏位类型")
    private String barType;

    @ApiModelProperty(value = "目标类型")
    private String targetType;

    @ApiModelProperty(value = "打开方式")
    private String windowOpenMode;

    @ApiModelProperty(value = "是否为首页")
    private Boolean homePageFlag;

    @ApiModelProperty(value = "适用商城")
    private String mallMode;

    @ApiModelProperty(value = "链接地址")
    private String linkAddress;

    @ApiModelProperty(value = "链接类型")
    private String linkType;

    @ApiModelProperty(value = "是否显示")
    private Boolean showFlag;

    @ApiModelProperty(value = "排序")
    private Integer sortNo;

    @ApiModelProperty(value = "上级栏目")
    private Long upperBarId;
}
