package com.elitescloud.cloudt.ucenter.api.vo.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Data
@ApiModel(description = "显示/隐藏入参")
public class AdInfoShowParam implements Serializable {

    private static final long serialVersionUID = 5771439104790143L;

    @ApiModelProperty(value = "广告id", required = true)
    @NotNull(message = "id不能为空")
    private Long id;

    @ApiModelProperty(value = "是否显示", required = true)
    @NotEmpty(message = "显示/隐藏不能为空")
    private String showFlag;

}
