package com.elitescloud.cloudt.ucenter.api.vo.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Data
@ApiModel(description = "文章排序号修改入参")
public class ArticleInfoSortParam implements Serializable {

    private static final long serialVersionUID = 5771439104790143L;

    @ApiModelProperty(value = "文章id", required = true)
    @NotNull(message = "id不能为空")
    private Long id;

    @ApiModelProperty(value = "排序号", required = true)
    @NotNull(message = "排序号不能为空")
    private Integer sortNo;

}
