package com.elitescloud.cloudt.ucenter.api.vo.param;


import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

@Data
@ApiModel(description = "消息分页查询入参")
public class MessagePagingParam extends AbstractOrderQueryParam {

    @ApiModelProperty(value = "消息标题")
    private String messageTitle;

    @ApiModelProperty(value = "消息分类code")
    private String categoryCode;

    @ApiModelProperty(value = "发布状态 0-未发布 1-已发布")
    private String publishStatus;

    @ApiModelProperty(value = "创建开始时间")
    private LocalDateTime beginTime;

    @ApiModelProperty(value = "创建结束时间")
    private LocalDateTime endTime;
}
