package com.elitescloud.cloudt.ucenter.api.vo.resp;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@ApiModel(description = "文章详情出参")
@Data
public class ArticleInfoDetailRespVO implements Serializable {
    private static final long serialVersionUID = 4406789299601680378L;

    @ApiModelProperty("文章作者")
    private String articleAuthor;

    @ApiModelProperty("分类id")
    private Long categoryId;

    @ApiModelProperty("文章名称")
    private String articleName;

    @ApiModelProperty("文章排序")
    private Integer sortNo;

    @ApiModelProperty(value = "是否显示 HIDE-隐藏 DISPLAY-显示")
    @SysCode(sys = Application.NAME, mod = "SHOW_FLAG")
    private String showFlag;

    @ApiModelProperty(value = "是否显示名称")
    private String showFlagName;

    @ApiModelProperty("文章分类名称")
    private String categoryName;

    @ApiModelProperty("文章详情")
    private String articleDetail;

    @ApiModelProperty("分类id")
    private List<Long> categoryIdList;
}
