package com.elitescloud.cloudt.ucenter.api.vo.resp;


import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.text.NumberFormat;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(description = "消息详情出参")
public class MessageDetailRespVO implements Serializable {

    @ApiModelProperty(value = "消息id")
    private Long id;

    @ApiModelProperty(value = "消息名称")
    private String messageTitle;

    @ApiModelProperty(value = "消息分类code")
    @SysCode(sys = Application.NAME, mod = "MESSAGE_CATEGORY")
    private String categoryCode;
    private String categoryCodeName;

    @ApiModelProperty(value = "发布状态 0-暂不发布 1-立即发布")
    @SysCode(sys = Application.NAME, mod = "PUBLISH_STATUS")
    private String publishStatus;
    private String publishStatusName;

    @ApiModelProperty(value = "消息描述")
    private String messageDetail;

//    @ApiModelProperty(value = "附件编码，文件服务器上的文件唯一标识")
//    private String fileCode;

    @ApiModelProperty(value = "消息接收者集合")
    private List<MessageReceiverRespVO> receiverList;

//    @ApiModelProperty(value = "附件编码集合，文件服务器上的文件唯一标识")
//    private List<String> fileCodeList;
//
//    @ApiModelProperty(value = "附件编码集合，文件服务器上的文件唯一标识")
//    private List<String> fileNameList;

    private List<AttachFileInfoVO> fileInfoList;

    @ApiModelProperty(value = "阅读进度")
    private String readProcess;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "发布时间")
    private LocalDateTime publishTime;

    @ApiModelProperty(value = "总人数")
    private String totalPeople;

    @ApiModelProperty(value = "总人数")
    private Integer totalCount;

    private String recordId;

    // 已读
    private int readCount;

    public String getTotalPeople() {
        return readCount + "/" + totalCount;
    }

    public String getReadProcess() {
        NumberFormat nf = NumberFormat.getPercentInstance();
        nf.setMinimumFractionDigits(2);
        if (ObjectUtil.equals(totalCount, 0)) {
            return "0.00%";
        }
        String readProcess = nf.format((double) readCount / totalCount);
        return readProcess;
    }
}
