package com.elitescloud.cloudt.ucenter.api.vo.resp;


import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.text.NumberFormat;
import java.time.LocalDateTime;

@Data
@ApiModel(description = "消息查询出参")
public class MessageRespVO implements Serializable {

    @ApiModelProperty(value = "消息标题")
    private String messageTitle;

    @ApiModelProperty(value = "消息id")
    private Long id;

    @ApiModelProperty(value = "消息分类code")
    @SysCode(sys = Application.NAME, mod = "MESSAGE_CATEGORY")
    private String categoryCode;
    private String categoryCodeName;

    @ApiModelProperty(value = "发布状态 0-暂不发布 1-立即发布")
    @SysCode(sys = Application.NAME, mod = "PUBLISH_STATUS")
    private String publishStatus;
    private String publishStatusName;

    @ApiModelProperty(value = "总人数")
    private String totalPeople;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "发布时间")
    private LocalDateTime publishTime;

    @ApiModelProperty(value = "阅读进度")
    private String readProcess;

    private Integer totalCount;

    private String recordId;

    @ApiModelProperty(value = "已读人数")
    private int readCount;

    public String getTotalPeople() {
        return readCount + "/" + totalCount;
    }

    public String getReadProcess() {
        NumberFormat nf = NumberFormat.getPercentInstance();
        nf.setMinimumFractionDigits(2);
        if (ObjectUtil.equals(totalCount, 0)) {
            return "0.00%";
        }
        String readProcess = nf.format((double) readCount / totalCount);
        return readProcess;
    }
}
