package com.elitescloud.cloudt.ucenter.api.vo.resp;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 网站栏位配置
 *
 * @author chaofeng.xia
 * @date 2023/5/23 15:21
 */
@Data
@ApiModel(description = "网站栏位配置")
public class WebsiteBarRespVO implements Serializable {

    private static final long serialVersionUID = 608334749926631L;
    private Long id;
    @ApiModelProperty(value = "栏位名称")
    private String barName;

    @ApiModelProperty(value = "栏位类型")
    @SysCode(sys = Application.NAME, mod = "WEBSITE_BAR_TYPE")
    private String barType;
    private String barTypeName;



    @ApiModelProperty(value = "目标类型")
    @SysCode(sys = Application.NAME, mod = "TARGET_TYPE")
    private String targetType;
    private String targetTypeName;

    @ApiModelProperty(value = "链接类型")
    @SysCode(sys = Application.NAME, mod = "LINK_TYPE")
    private String linkType;
    private String linkTypeName;

    @ApiModelProperty(value = "链接地址")
    private String linkAddress;

    @ApiModelProperty(value = "链接地址id")
    private Long linkAddressId;

    @ApiModelProperty(value = "上级id")
    private Long pid;

    @ApiModelProperty(value = "上级名称")
    private String pName;

    @ApiModelProperty(value = "打开方式")
    @SysCode(sys = Application.NAME, mod = "WINDOW_OPEN_MODE")
    private String windowOpenMode;
    private String windowOpenModeName;

    @ApiModelProperty(value = "是否显示")
    private Boolean showFlag;

    @ApiModelProperty(value = "排序")
    private Integer sortNo;

    @ApiModelProperty(value = "适用商城")
    @SysCode(sys = Application.NAME, mod = "MALL_MODE")
    private String mallMode;
    private String mallModeName;

    @ApiModelProperty(value = "子类")
    private List<WebsiteBarRespVO> child;

//    @ApiModelProperty(value = "是否为首页")
//    private Boolean homePageFlag;
//

}
