package com.elitescloud.cloudt.ucenter.api.vo.save;


import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(description = "广告新增编辑入参")
public class MessageSaveVO extends BaseModel implements Serializable {

    @ApiModelProperty(value = "消息名称")
    @NotBlank(message = "消息名称不能为空")
    private String messageTitle;

    @ApiModelProperty(value = "消息分类code")
    @NotBlank(message = "消息分类不能为空")
    private String categoryCode;

    @ApiModelProperty(value = "发布状态 0-未发布 1-已发布")
    private String publishStatus;

    @ApiModelProperty(value = "消息描述")
    private String messageDetail;

    @ApiModelProperty(value = "附件集合，文件服务器上的文件唯一标识")
    private List<FileInfoSaveVO> fileCodeList;

    @ApiModelProperty(value = "总人数")
    private Integer totalCount;

    @ApiModelProperty(value = "阅读进度")
    private String readProcess;

    @ApiModelProperty(value = "发布时间")
    private LocalDateTime publishTime;

    @ApiModelProperty(value = "消息接收者集合")
    private List<MessageReceiverSaveVO> receiverList;

}
