package com.elitescloud.cloudt.ucenter.api.vo.save;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 网站栏位配置
 *
 * @author chaofeng.xia
 * @date 2023/5/23 15:21
 */
@Data
@ApiModel(description = "网站栏位配置")
public class WebsiteBarSaveVO implements Serializable {

    private static final long serialVersionUID = 451763302546470747L;

    @ApiModelProperty(value = "网站栏目id")
    private Long id;

    @ApiModelProperty(value = "栏目名称", required = true)
    @NotBlank(message = "栏目名称不能为空")
    private String barName;

    @ApiModelProperty(value = "栏位类型", required = true)
//    @NotBlank(message = "栏位类型不能为空")
    private String barType;

    @ApiModelProperty(value = "栏位编码", required = true)
    private String barCode;

    @ApiModelProperty(value = "打开方式", required = true)
//    @NotBlank(message = "打开方式不能为空")
    private String windowOpenMode;

    @ApiModelProperty(value = "排序", required = true)
    private Integer sortNo;

    @ApiModelProperty(value = "适用商城", required = true)
    @NotBlank(message = "适用商城不能为空")
    private String mallMode;

    @ApiModelProperty(value = "是否为首页", required = true)
//    @NotNull(message = "是否为首页")
    private Boolean homePageFlag;

    @ApiModelProperty(value = "链接类型", required = true)
    @NotBlank(message = "链接类型不能为空")
    private String linkType;

    @ApiModelProperty(value = "是否显示", required = true)
    @NotNull(message = "是否显示不能为空")
    private Boolean showFlag;

    @ApiModelProperty(value = "上级栏位", required = true)
    private Long pid;

    @ApiModelProperty(value = "上级栏位名称", required = true)
    private String pName;

    @ApiModelProperty(value = "目标类型", required = true)
//    @NotBlank(message = "目标类型不能为空")
    private String targetType;

    @ApiModelProperty(value = "链接地址", required = true)
    @NotBlank(message = "链接地址不能为空")
    private String linkAddress;

    @ApiModelProperty(value = "链接地址id", required = true)
    private Long linkAddressId;
}
