package com.elitescloud.cloudt.ucenter.common.constant;

/**
 * 网站配置的
 *
 * @author chaofeng.xia
 * @date 2023/5/24 9:34
 */
public enum UdcEnum {

    /**
     * 网站类型 WS
     */
    WS_WEBSITE_TYPE_MIDDLE_MANAGEMENT("WS", "WEBSITE_TYPE", "网站类型", "MIDDLE_MANAGEMENT", "中台管理端"),
    WS_WEBSITE_TYPE_DEALER_PC("WS", "WEBSITE_TYPE", "网站类型", "DEALER_PC", "经销商/门店PC端"),
    WS_WEBSITE_TYPE_DEALER_APP("WS", "WEBSITE_TYPE", "网站类型", "DEALER_APP", "经销商/门店APP端"),
    WS_WEBSITE_TYPE_MEMBER_PC("WS", "WEBSITE_TYPE", "网站类型", "MEMBER_PC", "会员PC端"),
    WS_WEBSITE_TYPE_MEMBER_APP("WS", "WEBSITE_TYPE", "网站类型", "MEMBER_APP", "会员APP端"),
    WS_WEBSITE_TYPE_SUPPLIERS_PORTAL("WS", "WEBSITE_TYPE", "网站类型", "SUPPLIERS_PORTAL", "供应商协同门户"),
    WS_WEBSITE_TYPE_SALESMEN_APP("WS", "WEBSITE_TYPE", "网站类型", "SALESMEN_APP", "业务员APP端"),


    /**
     * 网站语言
     */
    WS_WEBSITE_LANGUAGE_zh_CN("WS", "WEBSITE_LANGUAGE", "网站语言", "zh_CN", "简体中文"),
    WS_WEBSITE_LANGUAGE_en("WS", "WEBSITE_LANGUAGE", "网站语言", "en_US", "English"),

    /**
     * 网站栏位类型
     */
    WS_WEBSITE_BAR_TYPE_NAV("WS", "WEBSITE_BAR_TYPE", "网站栏位类型", "NAV", "导航栏"),
    WS_WEBSITE_BAR_TYPE_BOTTOM("WS", "WEBSITE_BAR_TYPE", "网站栏位类型", "BOTTOM", "底栏"),
    WS_WEBSITE_BAR_TYPE_APP_NAV("WS", "WEBSITE_BAR_TYPE", "网站栏位类型", "APP_NAV", "APP导航栏"),


    /**
     * 网站栏位打开方式
     */
    WS_WINDOW_OPEN_MODE_NEW("WS", "WINDOW_OPEN_MODE", "网站栏位打开方式", "NEW", "新窗口"),
    WS_WINDOW_OPEN_MODE_CURRENT("WS", "WINDOW_OPEN_MODE", "网站栏位打开方式", "CURRENT", "当前窗口"),

    /**
     * 链接类型
     */
    WS_LINK_TYPE_INTERNAL("WS", "LINK_TYPE", "链接类型", "INTERNAL", "内部链接"),
    WS_LINK_TYPE_EXTERNAL("WS", "LINK_TYPE", "链接类型", "EXTERNAL", "外部链接"),
    WS_LINK_TYPE_MODE_CUSTOM("WS", "LINK_TYPE", "链接类型", "CUSTOM", "自定义"),

    /**
     * 商城模式
     */
    WS_MALL_TYPE_PC_B("WS", "MALL_MODE", "商城类型", "PC_B", "B端商城PC端"),
    WS_MALL_TYPE_PC_C("WS", "MALL_MODE", "商城类型", "PC_C", "C端商城PC端"),
    WS_MALL_TYPE_APP_B("WS", "MALL_MODE", "商城类型", "APP_B", "B端商城APP端"),
    WS_MALL_TYPE_APP_C("WS", "MALL_MODE", "商城类型", "APP_C", "C端商城APP端"),

    /**
     * 网站栏目目标类型
     */
    WS_TARGET_TYPE_ARTICLE("WS", "TARGET_TYPE", "网站栏目目标类型", "ARTICLE", "文章"),
    WS_TARGET_TYPE_GOODS("WS", "TARGET_TYPE", "网站栏目目标类型", "GOODS", "商品"),
    WS_TARGET_TYPE_ACTIVITY("WS", "TARGET_TYPE", "网站栏目目标类型", "ACTIVITY", "活动"),
    WS_TARGET_TYPE_AD("WS", "TARGET_TYPE", "网站栏目目标类型", "AD", "广告"),
    WS_TARGET_TYPE_OTHER("WS", "TARGET_TYPE", "网站栏目目标类型", "OTHER", "其他"),


    /**
     * 广告位展示形式
     */
    AD_SHOW_STYLE_WHEEL("AD", "SHOW_STYLE", "展示形式", "WHEEL", "轮播"),
    AD_SHOW_STYLE_FLAT("AD", "SHOW_STYLE", "展示形式", "FLAT", "平铺"),
    AD_SHOW_STYLE_POP("AD", "SHOW_STYLE", "展示形式", "POP", "弹窗"),

    /**
     * 是否显示
     */
    AD_SHOW_FLAG_DISPLAY("AD", "SHOW_FLAG", "是否显示", "DISPLAY", "显示"),
    AD_SHOW_FLAG_HIDE("AD", "SHOW_FLAG", "是否显示", "HIDE", "隐藏"),

    /**
     * 广告资源类型
     */
    AD_SOURCE_TYPE_IMG("AD", "SOURCE_TYPE", "广告资源类型", "1", "图片"),
    AD_SOURCE_TYPE_VIDEO("AD", "SOURCE_TYPE", "广告资源类型", "2", "视频"),

    /**
     * 网站主题颜色
     */
    WS_THEME_COLOR_DUSK("WS", "THEME_COLOR", "主题颜色", "#F5222D", "DUSK"),
    WS_THEME_COLOR_VOLCANO("WS", "THEME_COLOR", "主题颜色", "#FA541C", "VOLCANO"),
    WS_THEME_COLOR_SUNSET("WS", "THEME_COLOR", "主题颜色", "#FAAD14", "SUNSET"),
    WS_THEME_COLOR_BRIGHT_BLUE("WS", "THEME_COLOR", "主题颜色", "#13C2C2", "BRIGHT_BLUE"),
    WS_THEME_COLOR_AURORA_GREEN("WS", "THEME_COLOR", "主题颜色", "#52C41A", "AURORA_GREEN"),
    WS_THEME_COLOR_BLUE_DAWN("WS", "THEME_COLOR", "主题颜色", "#1890FF", "BLUE_DAWN"),
    WS_THEME_COLOR_EL_BLUE("WS", "THEME_COLOR", "主题颜色", "#2A4791", "EL_BLUE"),
    WS_THEME_DARK_REDDISH_PURPLE("WS", "THEME_COLOR", "主题颜色", "#722ED1", "DARK_REDDISH_PURPLE"),


    /**
     * 消息分类
     */
    MESSAGE_CATEGORY_LEANING_NOTICE("LM", "MESSAGE_CATEGORY", "消息分类", "LEANING_NOTICE", "学习通知"),
    MESSAGE_CATEGORY_NEW_PUSH("LM", "MESSAGE_CATEGORY", "消息分类", "NEW_PUSH", "新品推送"),
    MESSAGE_CATEGORY_PROMOTION_ACTIVITY("LM", "MESSAGE_CATEGORY", "消息分类", "PROMOTION_ACTIVITY", "优惠活动消息"),

    /**
     * 消息发布状态
     */
    MESSAGE_CATEGORY_PUBLISH_STATUS_1("LM", "PUBLISH_STATUS", "发布状态", "1", "已发布"),
    MESSAGE_CATEGORY_PUBLISH_STATUS_0("LM", "PUBLISH_STATUS", "发布状态", "0", "未发布"),

    /**
     * 消息阅读状态
     */
    MESSAGE_CATEGORY_READ_STATUS_1("LM", "PUBLISH_STATUS", "阅读状态", "1", "已阅读"),
    MESSAGE_CATEGORY_READ_STATUS_0("LM", "PUBLISH_STATUS", "阅读状态", "0", "未阅读"),
    MESSAGE_CATEGORY_READ_STATUS("LM", "PUBLISH_STATUS", "阅读状态", "-1", "草稿"),

    DATABASE_TYPE_MYSQL("yst-ucenter", "DATABASE_TYPE", "数据库类型", "MYSQL", "MYSQL"),
    DATABASE_TYPE_ORACLE("yst-ucenter", "DATABASE_TYPE", "数据库类型", "ORACLE", "ORACLE"),
    ;


    private final String model;
    private final String code;
    private final String codeName;
    private final String valueCode;
    private final String valueCodeName;

    UdcEnum(final String model, final String code, final String codeName, final String valueCode, final String valueCodeName) {
        this.model = model;
        this.code = code;
        this.codeName = codeName;
        this.valueCode = valueCode;
        this.valueCodeName = valueCodeName;
    }

    public String getValueCodeName() {
        return valueCodeName;
    }

    public String getValueCode() {
        return valueCode;
    }

    public String getMsg() {
        return valueCodeName;
    }

    public String getModel() {
        return model;
    }

    public String getCode() {
        return code;
    }

    public String getCodeName() {
        return codeName;
    }

}
