package com.elitescloud.cloudt.ucenter.controller;

import com.elitescloud.cloudt.common.base.ApiResult;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.ucenter.api.vo.param.*;
import com.elitescloud.cloudt.ucenter.api.vo.resp.AdInfoDetailRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.resp.AdInfoRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.resp.AdSpaceRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.save.AdInfoSaveVO;
import com.elitescloud.cloudt.ucenter.api.vo.save.AdSpaceSaveVO;
import com.elitescloud.cloudt.ucenter.service.AdManageService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping(value = "/ad/manage", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(tags = "广告管理")
@Slf4j
@RequiredArgsConstructor
public class AdManageController {

    private final AdManageService adManageService;

    @PostMapping(value = "/space/search")
    @ApiOperation(value = "广告位分页查询")
    @ApiOperationSupport(order = 1)
    public ApiResult<PagingVO<AdSpaceRespVO>> searchPagingList(@RequestBody AdSpacePagingParam searchParam) {
        return ApiResult.ok(adManageService.adSpacePagingSearch(searchParam));
    }

    @PostMapping(value = "/space/save")
    @ApiOperation(value = "编辑广告位")
    @ApiOperationSupport(order = 3)
    public ApiResult<Long> saveOrUpdateAdSpace(@RequestBody @Validated AdSpaceSaveVO saveVO) {
        return ApiResult.ok(adManageService.saveOrUpdateAdSpace(saveVO));
    }

//    @GetMapping(value = "/space/delete")
//    @ApiOperation(value = "删除广告位")
//    @ApiOperationSupport(order = 6)
//    public ApiResult<List<Long>> deleteAdSpace(List<Long> ids) {
//        return ApiResult.ok(adManageService.deleteAdSpace(ids));
//    }

    @PostMapping(value = "/info/save")
    @ApiOperation(value = "编辑/保存广告")
    @ApiOperationSupport(order = 3)
    public ApiResult<Long> articleSave(@RequestBody @Validated AdInfoSaveVO saveVO) {
        return ApiResult.ok(adManageService.saveOrUpdateAdInfo(saveVO));
    }

    @PostMapping(value = "/info/search")
    @ApiOperation(value = "广告信息分页查询")
    @ApiOperationSupport(order = 1)
    public ApiResult<PagingVO<AdInfoRespVO>> search(@RequestBody AdInfoPagingParam searchParam) {
        return ApiResult.ok(adManageService.search(searchParam));
    }

    @DeleteMapping(value = "/info/delete")
    @ApiOperation(value = "删除广告")
    @ApiOperationSupport(order = 6)
    public ApiResult<List<Long>> deleteAdInfo(@RequestBody List<Long> ids) {
        return ApiResult.ok(adManageService.deleteAdInfo(ids));
    }

//    @GetMapping(value = "/space/query")
//    @ApiOperation(value = "广告位下拉列表")
//    @ApiOperationSupport(order = 6)
//    public ApiResult<List<AdSpaceRespVO>> spaceQuery() {
//        List<String> adSpaceList = adManageService.queryAdSpace();
//        return ApiResult.ok(null);
//    }

    @PostMapping(value = "/show/update")
    @ApiOperation(value = "广告显示/隐藏编辑")
    public ApiResult<?> showUpdate(@RequestBody @Validated AdInfoShowParam param) {
        return ApiResult.ok(adManageService.showUpdate(param));
    }

    @PostMapping(value = "/sort/update")
    @ApiOperation(value = "广告排序编辑")
    public ApiResult<Integer> sortUpdate(@RequestBody @Validated AdInfoSortParam param) {
        return ApiResult.ok(adManageService.sortUpdate(param));
    }

    @GetMapping(value = "/info/query/{id}")
    @ApiOperation(value = "广告详情查询")
    @ApiOperationSupport(order = 1)
    public ApiResult<AdInfoDetailRespVO> queryInfoDetail(@PathVariable Long id) {
        return ApiResult.ok(adManageService.queryInfoDetail(id));
    }

    @PostMapping(value = "/link/address/")
    @ApiOperation(value = "查询目标链接地址")
    @ApiOperationSupport(order = 1)
    public ApiResult<?> queryLinkAddress(@RequestBody @Validated LinkAddressPagingParam param) {
        return ApiResult.ok(adManageService.queryLinkAddress(param));
    }

}