package com.elitescloud.cloudt.ucenter.controller;

import com.elitescloud.cloudt.common.base.ApiResult;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.ucenter.api.dto.CommonSearchDTO;
import com.elitescloud.cloudt.ucenter.api.vo.param.CommonSearchParam;
import com.elitescloud.cloudt.ucenter.api.vo.resp.CommonSearchVO;
import com.elitescloud.cloudt.ucenter.convert.CommonSearchConvert;
import com.elitescloud.cloudt.ucenter.service.CommonSearchService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @author : gyj
 * @Date : 2023/8/2
 */
@RestController
@RequestMapping("/commonSearch")
@RequiredArgsConstructor
@Api(value = "通查配置", tags = {"通查配置"})
public class CommonSearchController {

    private final CommonSearchService commonSearchService;

    @ApiOperation("新增/修改数据")
    @PostMapping("/insertOrUpdate")
    public ApiResult<Void> insertOrUpdate(@RequestBody CommonSearchParam commonSearchParam) {
        commonSearchService.insertOrUpdate(commonSearchParam);
        return ApiResult.ok();
    }

    @ApiOperation("删除数据")
    @GetMapping("/delete/{id}")
    public ApiResult<Void> delete(@PathVariable Long id) {
        commonSearchService.delete(id);
        return ApiResult.ok();
    }

    @ApiOperation("通用查询")
    @PostMapping("/page")
    public ApiResult<PagingVO<CommonSearchVO>> page(@RequestBody CommonSearchParam commonSearchParam) {
        PagingVO<CommonSearchDTO> commonSearchDTOPagingVO = commonSearchService.page(commonSearchParam);
        return ApiResult.ok(CommonSearchConvert.INSTANCE.commonSearchDTOPagingVO2CommonSearchVOPagingVO(commonSearchDTOPagingVO));
    }

    @ApiOperation("清除缓存")
    @GetMapping("/clearCache/{commonSearchId}")
    public ApiResult<Void> clearCache(@PathVariable String commonSearchId) {
        commonSearchService.clearCache(commonSearchId);
        return ApiResult.ok();
    }

    @ApiOperation("测试接口")
    @PostMapping("/testInterface")
    public ApiResult<List<Map>> testInterface(@RequestBody CommonSearchParam commonSearchParam) {
        return ApiResult.ok(commonSearchService.testInterface(commonSearchParam));
    }
}
