package com.elitescloud.cloudt.ucenter.controller;


import com.elitescloud.cloudt.common.base.ApiResult;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.ucenter.api.vo.param.MessagePagingParam;
import com.elitescloud.cloudt.ucenter.api.vo.param.MessageReceiverPagingParam;
import com.elitescloud.cloudt.ucenter.api.vo.param.PublishParam;
import com.elitescloud.cloudt.ucenter.api.vo.resp.MessageDetailRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.resp.MessageReceiverRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.resp.MessageRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.save.MessageSaveVO;
import com.elitescloud.cloudt.ucenter.service.MessageManageService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping(value = "/message/manage", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(tags = "自定义消息管理")
@Slf4j
@RequiredArgsConstructor
public class MessageManageController {

    private final MessageManageService messageManageService;

    @PostMapping(value = "/save")
    @ApiOperation(value = "编辑保存消息")
    @ApiOperationSupport(order = 7)
    public ApiResult<Long> messageSave(@RequestBody @Validated MessageSaveVO saveVO) {
        return ApiResult.ok(messageManageService.saveOrUpdate(saveVO));
    }

    @DeleteMapping(value = "/delete")
    @ApiOperation(value = "删除消息")
    @ApiOperationSupport(order = 7)
    public ApiResult<?> delete(@RequestBody List<Long> ids) {
        return ApiResult.ok(messageManageService.delete(ids));
    }

    @PostMapping(value = "/search")
    @ApiOperation(value = "列表查询")
    @ApiOperationSupport(order = 7)
    public ApiResult<PagingVO<MessageRespVO>> search(@RequestBody @Validated MessagePagingParam param) {
        return ApiResult.ok(messageManageService.search(param));
    }

    @GetMapping(value = "/detail/query/{id}")
    @ApiOperation(value = "详情查询")
    @ApiOperationSupport(order = 7)
    public ApiResult<MessageDetailRespVO> queryDetail(@PathVariable Long id) {
        return ApiResult.ok(messageManageService.queryDetail(id));
    }

    @PostMapping(value = "/receiver/search")
    @ApiOperation(value = "消息接收者分页查询")
    @ApiOperationSupport(order = 7)
    public ApiResult<PagingVO<MessageReceiverRespVO>> searchReceiver(@RequestBody MessageReceiverPagingParam param) {
        return ApiResult.ok(messageManageService.searchReceiver(param));
    }

    @PostMapping(value = "/publish")
    @ApiOperation(value = "发布消息")
    @ApiOperationSupport(order = 7)
    public ApiResult<?> publish(@RequestBody PublishParam param) {
        return ApiResult.ok(messageManageService.publish(param));
    }
}
