package com.elitescloud.cloudt.ucenter.controller;


import com.elitescloud.cloudt.common.base.ApiResult;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.ucenter.api.vo.param.GenerateTableParam;
import com.elitescloud.cloudt.ucenter.api.vo.param.ReceiptSourceConfigPagingParam;
import com.elitescloud.cloudt.ucenter.api.vo.resp.ReceiptSourceConfigDetailPagingRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.resp.ReceiptSourceConfigPagingRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.save.ReceiptSourceConfigSaveVO;
import com.elitescloud.cloudt.ucenter.service.ReceiptSourceConfigService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

@RestController
@RequestMapping(value = "/receipt/source/config", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(tags = "单据来源配置")
@Slf4j
@RequiredArgsConstructor
public class ReceiptSourceConfigController {

    private final ReceiptSourceConfigService receiptSourceConfigService;


    @PostMapping(value = "/save")
    @ApiOperation(value = "单据来源配置编辑/修改")
    @ApiOperationSupport(order = 1)
    public ApiResult<Long> save(@RequestBody @Valid ReceiptSourceConfigSaveVO saveVO) {
        return ApiResult.ok(receiptSourceConfigService.save(saveVO));
    }

    @DeleteMapping(value = "/delete")
    @ApiOperation(value = "单据来源配置删除")
    @ApiOperationSupport(order = 1)
    public ApiResult<?> delete(@RequestBody List<Long> ids) {
        return ApiResult.ok(receiptSourceConfigService.delete(ids));
    }

    @PostMapping(value = "/search")
    @ApiOperation(value = "单据来源配置分页查询")
    @ApiOperationSupport(order = 1)
    public ApiResult<PagingVO<ReceiptSourceConfigPagingRespVO>> searchPaging(@RequestBody ReceiptSourceConfigPagingParam param) {
        return ApiResult.ok(receiptSourceConfigService.searchPaging(param));
    }

    @PostMapping(value = "/detail/search")
    @ApiOperation(value = "来源配置明细分页查询")
    @ApiOperationSupport(order = 1)
    public ApiResult<PagingVO<ReceiptSourceConfigDetailPagingRespVO>> detailSearchPaging(@RequestBody @Validated ReceiptSourceConfigPagingParam param) {
        return ApiResult.ok(receiptSourceConfigService.detailSearchPaging(param));
    }

    @PostMapping(value = "/generate/table")
    @ApiOperation(value = "单据来源配置生成表体")
    @ApiOperationSupport(order = 1)
    public ApiResult<?> generateTable(@RequestBody GenerateTableParam param) {
        return ApiResult.ok(receiptSourceConfigService.generateTable(param));
    }


    @PostMapping(value = "/test")
    @ApiOperation(value = "来源单据测试")
    @ApiOperationSupport(order = 1)
    public ApiResult<?> test(String sourceNo) {
        return ApiResult.ok(receiptSourceConfigService.test(sourceNo));
    }
}
