package com.elitescloud.cloudt.ucenter.controller;

import com.elitescloud.cloudt.common.base.ApiResult;

import com.elitescloud.cloudt.ucenter.api.vo.resp.WebsiteAppearanceVO;
import com.elitescloud.cloudt.ucenter.api.vo.save.WebsiteAppearanceSaveVO;
import com.elitescloud.cloudt.ucenter.service.WebsiteAppearanceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * 网站外观配置
 *
 * @author chaofeng.xia
 * @date 2023/5/26 16:01
 */
@RestController
@RequestMapping(value = "/website/appearance", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(value = "网站外观配置信息", tags = {"网站外观配置信息"})
@RequiredArgsConstructor
@Validated
public class WebsiteAppearanceController {

    private final WebsiteAppearanceService appearanceService;

    @GetMapping(value = "/findByType/{type}")
    @ApiOperation(value = "查询 - 根据网站类型查询")
    public ApiResult<WebsiteAppearanceVO> findByType(@PathVariable String type) {
        return ApiResult.ok(appearanceService.findByType(type));
    }

    @GetMapping(value = "/findById/{id}")
    @ApiOperation(value = "查询 - 根据id查询")
    public ApiResult<WebsiteAppearanceVO> findById(@PathVariable Long id) {
        return ApiResult.ok(appearanceService.findById(id));
    }

    @PostMapping(value = "/save")
    @ApiOperation(value = "保存数据")
    public ApiResult<Long> save(@RequestBody @Valid WebsiteAppearanceSaveVO appearanceSaveVO) {
        return ApiResult.ok(appearanceService.save(appearanceSaveVO));
    }
}
