package com.elitescloud.cloudt.ucenter.convert;

import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitescloud.cloudt.ucenter.api.dto.WebsiteAppearanceDTO;
import com.elitescloud.cloudt.ucenter.api.vo.resp.AttachFileInfoVO;
import com.elitescloud.cloudt.ucenter.api.vo.resp.MessageDetailRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.resp.MessageReceiverRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.resp.MessageRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.save.FileInfoSaveVO;
import com.elitescloud.cloudt.ucenter.api.vo.save.MessageReceiverSaveVO;
import com.elitescloud.cloudt.ucenter.api.vo.save.MessageSaveVO;
import com.elitescloud.cloudt.ucenter.api.vo.save.WebsiteAppearanceSaveVO;
import com.elitescloud.cloudt.ucenter.entity.FileInfoDO;
import com.elitescloud.cloudt.ucenter.entity.MessageInfoDO;
import com.elitescloud.cloudt.ucenter.entity.MessageReceiverDO;
import com.elitescloud.cloudt.ucenter.entity.WebsiteAppearanceDO;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * 网站外观配置信息表
 *
 * @author chaofeng.xia
 * @date 2023/5/23 16:12
 */
@Mapper(config = BaseMapperConfig.class)
public interface MessageManageConvert {

    MessageManageConvert INSTANCE = Mappers.getMapper(MessageManageConvert.class);

    /**
     * do转saveVo
     *
     * @param demoDO saveDo
     * @return vo
     */
    WebsiteAppearanceSaveVO do2SaveVo(WebsiteAppearanceDO demoDO);

    /**
     * do转dto
     *
     * @param websiteAppearanceDO do
     * @return dto
     */
    WebsiteAppearanceDTO do2Dto(WebsiteAppearanceDO websiteAppearanceDO);


    MessageInfoDO messageSaveVo2Do(MessageSaveVO saveVO);

    List<MessageReceiverDO> receiverVos2Dos(List<MessageReceiverSaveVO> receiverList);

    MessageDetailRespVO messageDo2Vo(MessageInfoDO messageInfoDO);

    List<MessageInfoDO> messageRespVos2Dos(List<MessageRespVO> records);

    List<FileInfoDO> fileVos2Dos(List<FileInfoSaveVO> fileCodeList);

    List<AttachFileInfoVO> fileDos2Vos(List<FileInfoDO> doList);

    List<MessageReceiverRespVO> receiverDos2Vos(List<MessageReceiverDO> receiverDoList);
}
