package com.elitescloud.cloudt.ucenter.dto;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.ucenter.api.vo.resp.ArticleInfoRespVO;
import com.elitescloud.cloudt.ucenter.utils.TreeNode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@ApiModel(description = "文章分类新增编辑返参")
@Data
public class ArticleCategoryDTO implements TreeNode<ArticleCategoryDTO> {

    private static final long serialVersionUID = 440789299601680378L;

    @ApiModelProperty("文章分类id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("文章分类名称")
    private String categoryName;

    @ApiModelProperty(value = "排序序号")
    private Integer sortNo;

    @ApiModelProperty(value = "是否显示 HIDE-隐藏 DISPLAY-显示")
    @SysCode(sys =  Application.NAME, mod = "SHOW_FLAG")
    private String showFlag;
    private String showFlagName;

    @ApiModelProperty("上级分类id")
    private Long pid;

    @ApiModelProperty("上级分类名称")
    private String pName;

    @ApiModelProperty(value = "文章分类下级")
    private List<ArticleCategoryDTO> treeNodes;

    @ApiModelProperty("文章分类中文章信息")
    private List<ArticleInfoRespVO> articleInfoRespVOS;

    @ApiModelProperty(value = "一级分类id")
    private Long rootId;

    @Override
    public void setIsLeaf(Boolean isLeaf) {

    }
}
